/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.gui.InjectContext;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.InventoryMenuTransition;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.gui.MenuTransition;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryMenu
implements Listener,
Runnable {
    private final List<Runnable> closeCallbacks = Lists.newArrayList();
    private boolean closingViews;
    private boolean delayViewerChanges;
    private PageContext page;
    private int pickupAmount = -1;
    private final Deque<PageContext> stack = Queues.newArrayDeque();
    private boolean transitioning;
    private Collection<InventoryView> views = Lists.newArrayList();
    private static Map<Class<? extends InventoryMenuPage>, InventoryMenuInfo> CACHED_INFOS = new WeakHashMap<Class<? extends InventoryMenuPage>, InventoryMenuInfo>();

    public InventoryMenu(InventoryMenuInfo info, InventoryMenuPage instance) {
        this.transition(info, instance, Maps.newHashMap());
    }

    private InventoryMenu(InventoryMenuInfo info, Map<String, Object> context) {
        this.transition(info, info.createInstance(), context);
    }

    private boolean acceptFilter(InventoryAction needle, InventoryAction[] haystack) {
        for (InventoryAction type : haystack) {
            if (needle != type) continue;
            return true;
        }
        return haystack.length == 0;
    }

    private void addCloseCallback(Runnable run) {
        this.closeCallbacks.add(run);
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
        this.closingViews = true;
        this.runViewerModifier(() -> {
            for (InventoryView view : this.views) {
                if (this.page != null) {
                    this.page.page.onClose(view.getPlayer());
                }
                view.close();
            }
            this.views.clear();
            this.closingViews = false;
        });
    }

    public void close(HumanEntity entity) {
        this.closingViews = true;
        this.runViewerModifier(() -> {
            Iterator<InventoryView> itr = this.views.iterator();
            while (itr.hasNext()) {
                InventoryView view = itr.next();
                if (view.getPlayer() != entity) continue;
                view.close();
                itr.remove();
            }
            this.closingViews = false;
        });
    }

    private InventoryMenuSlot createSlot(int pos, MenuSlot slotInfo) {
        InventoryMenuSlot slot = this.page.ctx.getSlot(pos);
        slot.initialise(slotInfo);
        return slot;
    }

    private InventoryMenuTransition createTransition(int pos, MenuTransition transitionInfo) {
        InventoryMenuSlot slot = this.page.ctx.getSlot(pos);
        InventoryMenuTransition transition = new InventoryMenuTransition(slot, transitionInfo.value());
        return transition;
    }

    private int getInventorySize(InventoryType type, int[] dim) {
        switch (type) {
            case CHEST: {
                int size = dim[0] * dim[1];
                if (size % 9 != 0) {
                    size += 9 - size % 9;
                }
                dim[0] = Math.min(54, size) / 9;
                dim[1] = 9;
                return Math.max(9, Math.min(54, size));
            }
            case ANVIL: 
            case BLAST_FURNACE: 
            case CARTOGRAPHY: 
            case FURNACE: 
            case GRINDSTONE: 
            case SMITHING: 
            case SMOKER: {
                dim[0] = 0;
                dim[1] = 3;
                return 3;
            }
            case BARREL: 
            case ENDER_CHEST: 
            case SHULKER_BOX: {
                dim[0] = 3;
                dim[1] = 9;
                return 27;
            }
            case BEACON: 
            case LECTERN: {
                dim[0] = 0;
                dim[1] = 1;
                return 1;
            }
            case BREWING: 
            case HOPPER: {
                dim[0] = 0;
                dim[1] = 5;
                return 5;
            }
            case DISPENSER: 
            case DROPPER: {
                dim[0] = 0;
                dim[1] = 9;
                return 9;
            }
            case ENCHANTING: 
            case STONECUTTER: {
                dim[0] = 0;
                dim[1] = 2;
                return 2;
            }
            case LOOM: {
                dim[0] = 0;
                dim[1] = 4;
                return 4;
            }
            case PLAYER: {
                dim[0] = 4;
                dim[1] = 9;
                return 41;
            }
            case WORKBENCH: {
                dim[0] = 0;
                dim[1] = 10;
                return 10;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void handleClick(InventoryClickEvent event) {
        Inventory clicked;
        Inventory inventory = clicked = event.getClickedInventory() != null ? event.getClickedInventory() : event.getInventory();
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            if (!this.views.stream().anyMatch(v -> event.getWhoClicked().equals(v.getPlayer()))) {
                return;
            }
            event.setCancelled(true);
            PlayerInventory dest = event.getInventory() == event.getClickedInventory() ? event.getWhoClicked().getInventory() : this.page.ctx.getInventory();
            boolean toNPC = dest == this.page.ctx.getInventory();
            this.handleShiftClick(event, (Inventory)dest, toNPC);
            return;
        }
        if (!this.isOurInventory(clicked)) {
            return;
        }
        switch (event.getAction()) {
            case COLLECT_TO_CURSOR: {
                event.setCancelled(true);
            }
            case UNKNOWN: 
            case DROP_ONE_CURSOR: 
            case DROP_ALL_CURSOR: {
                return;
            }
        }
        if (event.getSlot() < 0) {
            return;
        }
        InventoryMenuSlot slot = this.page.ctx.getSlot(event.getSlot());
        CitizensInventoryClickEvent ev = new CitizensInventoryClickEvent(event, this.pickupAmount);
        PageContext pg = this.page;
        slot.onClick(ev);
        this.pickupAmount = -1;
        pg.page.onClick(slot, event);
        if (pg != this.page) {
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            return;
        }
        for (InventoryMenuTransition transition : this.page.transitions) {
            Class<? extends InventoryMenuPage> next = transition.accept(slot);
            if (next == null) continue;
            event.setCancelled(true);
            this.transition(next);
            break;
        }
    }

    private void handleShiftClick(InventoryClickEvent event, Inventory dest, boolean toNPC) {
        if (event.getCurrentItem() == null) {
            return;
        }
        int amount = event.getCurrentItem().getAmount();
        ItemStack merging = new ItemStack(event.getCurrentItem().clone());
        ItemStack[] contents = dest.getContents();
        PageContext pg = this.page;
        for (int i = 0; i < contents.length && pg == this.page; ++i) {
            InventoryAction action;
            if (contents[i] == null || contents[i].getType() == Material.AIR) {
                merging.setAmount(amount);
                if (toNPC) {
                    event.getView().setCursor(merging);
                }
                InventoryClickEvent e = new InventoryClickEvent(event.getView(), event.getSlotType(), toNPC ? i : event.getRawSlot(), event.getClick(), toNPC ? InventoryAction.PLACE_ALL : InventoryAction.PICKUP_ALL);
                this.onInventoryClick(e);
                if (toNPC) {
                    event.getView().setCursor(null);
                }
                if (!e.isCancelled()) {
                    dest.setItem(i, merging);
                    event.setCurrentItem(null);
                    break;
                }
                if (dest.getItem(i) == null || !dest.getItem(i).isSimilar(merging)) continue;
                break;
            }
            if (!contents[i].isSimilar(event.getCurrentItem())) continue;
            ItemStack stack = contents[i].clone();
            merging.setAmount(Math.min(amount, stack.getType().getMaxStackSize() - stack.getAmount()));
            if (toNPC) {
                event.getView().setCursor(merging);
                action = amount - merging.getAmount() <= 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_SOME;
            } else {
                action = amount - merging.getAmount() <= 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_SOME;
                this.pickupAmount = merging.getAmount();
            }
            InventoryClickEvent e = new InventoryClickEvent(event.getView(), event.getSlotType(), toNPC ? i : event.getRawSlot(), event.getClick(), action);
            this.onInventoryClick(e);
            if (toNPC) {
                event.getView().setCursor(null);
            }
            if (e.isCancelled()) continue;
            stack.setAmount(stack.getAmount() + merging.getAmount());
            dest.setItem(i, stack);
            event.getCurrentItem().setAmount(amount -= merging.getAmount());
            if (amount <= 0) break;
        }
    }

    private boolean isOurInventory(Inventory other) {
        if (other instanceof ForwardingInventory && ((ForwardingInventory)other).getWrapped().equals(this.page.ctx.getInventory())) {
            return true;
        }
        return other.equals(this.page.ctx.getInventory());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.page == null || this.transitioning || this.closingViews) {
            if (this.transitioning && this.isOurInventory(event.getClickedInventory() != null ? event.getClickedInventory() : event.getInventory())) {
                event.setCancelled(true);
            }
            return;
        }
        this.delayViewerChanges = true;
        try {
            this.handleClick(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.getWhoClicked().closeInventory();
        }
        this.delayViewerChanges = false;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.page == null || !this.isOurInventory(event.getInventory()) || this.closingViews) {
            return;
        }
        this.delayViewerChanges = true;
        this.transitionBack();
        this.delayViewerChanges = false;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.page != null && this.isOurInventory(event.getInventory())) {
            event.setCancelled(true);
        }
    }

    private InventoryView openInventory(HumanEntity player, Inventory inventory, String title) {
        InventoryView view = inventory.getType() == InventoryType.ANVIL ? CitizensAPI.getNMSHelper().openAnvilInventory((Player)player, inventory, title) : player.openInventory(inventory);
        if (view == null) {
            throw new RuntimeException("null inventory opened " + player + " " + inventory + " " + title);
        }
        return view;
    }

    private InventoryMenuPattern parsePattern(int[] dim, List<InventoryMenuTransition> transitions, Bindable<MenuPattern> patternInfo) {
        String pattern = ((MenuPattern)patternInfo.data).value();
        HashMap slotMap = Maps.newHashMap();
        for (MenuSlot slot : ((MenuPattern)patternInfo.data).slots()) {
            slotMap.put(Character.valueOf(slot.pat()), slot);
        }
        HashMap transitionMap = Maps.newHashMap();
        for (MenuTransition transition : ((MenuPattern)patternInfo.data).transitions()) {
            transitionMap.put(Character.valueOf(transition.pat()), transition);
        }
        ArrayList patternSlots = Lists.newArrayList();
        ArrayList patternTransitions = Lists.newArrayList();
        int row = 0;
        int col = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            MenuTransition transition;
            char c = pattern.charAt(i);
            if (c == '\n' || c == '\\' && i + 1 < pattern.length() && pattern.charAt(i + 1) == 'n') {
                if (c != '\n') {
                    ++i;
                }
                ++row;
                col = 0;
                continue;
            }
            int[] pos = ((MenuPattern)patternInfo.data).offset();
            pos[0] = pos[0] + row;
            pos[1] = pos[1] + col;
            MenuSlot slot = (MenuSlot)slotMap.get(Character.valueOf(c));
            if (slot != null) {
                patternSlots.add(this.createSlot(this.posToIndex(dim, pos), slot));
            }
            if ((transition = (MenuTransition)transitionMap.get(Character.valueOf(c))) != null) {
                InventoryMenuTransition concreteTransition = this.createTransition(this.posToIndex(dim, pos), transition);
                patternTransitions.add(concreteTransition);
                transitions.add(concreteTransition);
            }
            ++col;
        }
        return new InventoryMenuPattern((MenuPattern)patternInfo.data, patternSlots, patternTransitions);
    }

    private int posToIndex(int[] dim, int[] pos) {
        return pos[0] * dim[1] + pos[1];
    }

    public void present(HumanEntity player) {
        this.views.add(this.openInventory(player, this.page.ctx.getInventory(), this.page.ctx.getTitle()));
    }

    @Override
    public void run() {
        if (this.page == null || this.transitioning) {
            return;
        }
        this.page.page.run();
    }

    private void runViewerModifier(Runnable run) {
        if (this.delayViewerChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), run);
        } else {
            run.run();
        }
    }

    public void transition(Class<? extends InventoryMenuPage> clazz) {
        this.transition(clazz, (Map<String, Object>)Maps.newHashMap());
    }

    public void transition(Class<? extends InventoryMenuPage> clazz, Map<String, Object> context) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        InventoryMenuInfo info = CACHED_INFOS.get(clazz);
        this.transition(info, info.createInstance(), context);
    }

    private void transition(InventoryMenuInfo info, InventoryMenuPage instance, Map<String, Object> context) {
        int pos;
        int i;
        int size;
        InventoryType type;
        if (this.page != null) {
            for (Map.Entry<String, Object> entry : this.page.ctx.data().entrySet()) {
                context.putIfAbsent(entry.getKey(), entry.getValue());
            }
            this.page.ctx.data().clear();
            this.stack.addLast(this.page);
        }
        this.page = new PageContext();
        this.page.page = instance;
        int[] dim = info.menuAnnotation.dimensions();
        String title = Messaging.parseComponents(Messaging.tryTranslate(context.containsKey("title") ? (String)context.get("title") : info.menuAnnotation.title()));
        Inventory inventory = instance.createInventory(title);
        if (inventory == null) {
            type = info.menuAnnotation.type();
            size = this.getInventorySize(type, dim);
            inventory = type == InventoryType.CHEST || type == null ? Bukkit.createInventory(null, (int)size, (String)title) : Bukkit.createInventory(null, (InventoryType)type, (String)title);
        } else {
            type = inventory.getType();
            size = this.getInventorySize(type, dim);
        }
        ArrayList transitions = Lists.newArrayList();
        InventoryMenuSlot[] slots = new InventoryMenuSlot[inventory.getSize()];
        PageContext.access$402(this.page, new InventoryMenuPattern[info.patterns.length]);
        this.page.ctx = new MenuContext(this, slots, inventory, title, context);
        for (i = 0; i < info.slots.length; ++i) {
            Bindable<MenuSlot> slotInfo = info.slots[i];
            pos = this.posToIndex(dim, ((MenuSlot)slotInfo.data).slot());
            InventoryMenuSlot slot = this.createSlot(pos, (MenuSlot)slotInfo.data);
            slotInfo.bind(this.page.page, slot);
        }
        for (i = 0; i < info.transitions.length; ++i) {
            Bindable<MenuTransition> transitionInfo = info.transitions[i];
            pos = this.posToIndex(dim, ((MenuTransition)transitionInfo.data).pos());
            InventoryMenuTransition transition = this.createTransition(pos, (MenuTransition)transitionInfo.data);
            transitionInfo.bind(this.page.page, transition);
            transitions.add(transition);
        }
        for (i = 0; i < info.patterns.length; ++i) {
            Bindable<MenuPattern> patternInfo = info.patterns[i];
            InventoryMenuPattern pattern = this.parsePattern(dim, transitions, patternInfo);
            patternInfo.bind(this.page.page, pattern);
            ((PageContext)this.page).patterns[i] = pattern;
        }
        PageContext.access$202(this.page, transitions.toArray(new InventoryMenuTransition[transitions.size()]));
        info.inject(this.page.page, this.page.ctx.data());
        this.page.page.initialise(this.page.ctx);
        for (Invokable<ClickHandler> invokable : info.clickHandlers) {
            int idx = this.posToIndex(dim, ((ClickHandler)((Invokable)invokable).data).slot());
            InventoryMenuSlot slot = this.page.ctx.getSlot(idx);
            slot.addClickHandler(event -> {
                if (event.getSlot() != idx) {
                    return;
                }
                if (this.acceptFilter(event.getAction(), ((ClickHandler)((Invokable)invokable).data).filter())) {
                    try {
                        ((Invokable)invokable).method.invoke(this.page.page, slot, (CitizensInventoryClickEvent)((Object)event));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                } else {
                    event.setCancelled(true);
                    event.setResult(Event.Result.DENY);
                    return;
                }
            });
        }
        this.transitionViewersToInventory(inventory);
    }

    public void transition(InventoryMenuPage instance) {
        this.transition(instance, (Map<String, Object>)Maps.newHashMap());
    }

    public void transition(InventoryMenuPage instance, Map<String, Object> context) {
        Class<?> clazz = instance.getClass();
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        InventoryMenuInfo info = CACHED_INFOS.get(clazz);
        this.transition(info, instance, context);
    }

    public void transitionBack() {
        if (this.page == null) {
            return;
        }
        for (InventoryView view : this.views) {
            this.page.page.onClose(view.getPlayer());
        }
        Map<String, Object> data = this.page.ctx.data();
        this.page = this.stack.pollLast();
        if (this.page != null) {
            this.page.ctx.data().putAll(data);
            this.page.page.initialise(this.page.ctx);
        }
        data.clear();
        this.transitionViewersToInventory(this.page == null ? null : this.page.ctx.getInventory());
        if (this.page == null) {
            for (Runnable callback : this.closeCallbacks) {
                callback.run();
            }
        }
    }

    private void transitionViewersToInventory(Inventory inventory) {
        if (this.views.size() == 0) {
            return;
        }
        this.transitioning = true;
        this.runViewerModifier(() -> {
            Collection<InventoryView> old = this.views;
            this.views = Lists.newArrayListWithExpectedSize((int)old.size());
            for (InventoryView view : old) {
                view.close();
                if (!view.getPlayer().isValid() || inventory == null) continue;
                this.views.add(this.openInventory(view.getPlayer(), inventory, this.page.ctx.getTitle()));
            }
            this.transitioning = false;
        });
    }

    void updateTitle(String newTitle) {
        for (InventoryView view : this.views) {
            CitizensAPI.getNMSHelper().updateInventoryTitle((Player)view.getPlayer(), view, newTitle);
        }
    }

    private static void cacheInfo(Class<? extends InventoryMenuPage> clazz) {
        InventoryMenuInfo info = new InventoryMenuInfo(clazz);
        info.menuAnnotation = clazz.getAnnotation(Menu.class);
        if (info.menuAnnotation == null) {
            throw new IllegalArgumentException("Missing menu annotation");
        }
        try {
            Constructor<? extends InventoryMenuPage> found = clazz.getDeclaredConstructor(new Class[0]);
            found.setAccessible(true);
            info.constructor = found;
        }
        catch (NoSuchMethodException found) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CACHED_INFOS.put(clazz, info);
    }

    public static InventoryMenu create(Class<? extends InventoryMenuPage> clazz) {
        return InventoryMenu.createWithContext(clazz, Maps.newHashMap());
    }

    public static InventoryMenu create(InventoryMenuPage instance) {
        Class<?> clazz = instance.getClass();
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        return new InventoryMenu(CACHED_INFOS.get(clazz), instance);
    }

    public static InventoryMenu createSelfRegistered(Class<? extends InventoryMenuPage> clazz) {
        InventoryMenu menu = InventoryMenu.create(clazz);
        Bukkit.getPluginManager().registerEvents((Listener)menu, CitizensAPI.getPlugin());
        menu.addCloseCallback(() -> HandlerList.unregisterAll((Listener)menu));
        return menu;
    }

    public static InventoryMenu createSelfRegistered(InventoryMenuPage instance) {
        InventoryMenu menu = InventoryMenu.create(instance);
        Bukkit.getPluginManager().registerEvents((Listener)menu, CitizensAPI.getPlugin());
        menu.addCloseCallback(() -> HandlerList.unregisterAll((Listener)menu));
        return menu;
    }

    public static InventoryMenu createWithContext(Class<? extends InventoryMenuPage> clazz, Map<String, Object> context) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        return new InventoryMenu(CACHED_INFOS.get(clazz), context);
    }

    private static class InventoryMenuInfo {
        final Invokable<ClickHandler>[] clickHandlers;
        Constructor<? extends InventoryMenuPage> constructor;
        final Map<String, MethodHandle> injectables;
        Menu menuAnnotation;
        final Bindable<MenuPattern>[] patterns;
        final Bindable<MenuSlot>[] slots;
        final Bindable<MenuTransition>[] transitions;
        private static MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

        public InventoryMenuInfo(Class<?> clazz) {
            this.patterns = this.getBindables(clazz, MenuPattern.class, InventoryMenuPattern.class);
            this.slots = this.getBindables(clazz, MenuSlot.class, InventoryMenuSlot.class);
            this.transitions = this.getBindables(clazz, MenuTransition.class, InventoryMenuTransition.class);
            this.clickHandlers = this.getClickHandlers(clazz);
            this.injectables = this.getInjectables(clazz);
        }

        public InventoryMenuPage createInstance() {
            if (this.constructor == null) {
                throw new RuntimeException("no constructor provided");
            }
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private <T extends Annotation> Bindable<T>[] getBindables(Class<?> clazz, Class<T> annotationType, Class<?> concreteType) {
            ArrayList bindables = Lists.newArrayList();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Annotation[] annotations = field.getAnnotationsByType(annotationType);
                MethodHandle bind = null;
                if (field.getType() == concreteType) {
                    try {
                        bind = LOOKUP.unreflectSetter(field);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                for (Annotation t : annotations) {
                    bindables.add(new Bindable<Annotation>(bind, t));
                }
            }
            ArrayList reflect = Lists.newArrayList();
            reflect.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
            reflect.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            for (AccessibleObject object : reflect) {
                object.setAccessible(true);
                for (Annotation t : object.getAnnotationsByType(annotationType)) {
                    bindables.add(new Bindable<Annotation>(null, t));
                }
            }
            for (Annotation t : clazz.getAnnotationsByType(annotationType)) {
                bindables.add(new Bindable<Annotation>(null, t));
            }
            return bindables.toArray(new Bindable[bindables.size()]);
        }

        private Invokable<ClickHandler>[] getClickHandlers(Class<?> clazz) {
            ArrayList invokables = Lists.newArrayList();
            for (Method method : clazz.getDeclaredMethods()) {
                method.setAccessible(true);
                for (ClickHandler clickHandler : (ClickHandler[])method.getAnnotationsByType(ClickHandler.class)) {
                    try {
                        invokables.add(new Invokable<ClickHandler>(clickHandler, LOOKUP.unreflect(method)));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                for (Annotation annotation : (MenuSlot[])method.getAnnotationsByType(MenuSlot.class)) {
                    try {
                        invokables.add(new Invokable<1>(new ClickHandler(){
                            final /* synthetic */ MenuSlot val$slot;
                            {
                                this.val$slot = menuSlot;
                            }

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return ClickHandler.class;
                            }

                            @Override
                            public InventoryAction[] filter() {
                                return new InventoryAction[0];
                            }

                            @Override
                            public int[] slot() {
                                return this.val$slot.slot();
                            }
                        }, LOOKUP.unreflect(method)));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            return invokables.toArray(new Invokable[invokables.size()]);
        }

        private Map<String, MethodHandle> getInjectables(Class<?> clazz) {
            HashMap injectables = Maps.newHashMap();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(InjectContext.class)) continue;
                try {
                    injectables.put(field.getName(), LOOKUP.unreflectSetter(field));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return injectables;
        }

        public void inject(Object instance, Map<String, Object> data) {
            for (Map.Entry<String, MethodHandle> entry : this.injectables.entrySet()) {
                Object raw = data.get(entry.getKey());
                if (raw == null) continue;
                try {
                    entry.getValue().invoke(instance, raw);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class PageContext {
        private MenuContext ctx;
        private InventoryMenuPage page;
        private InventoryMenuPattern[] patterns;
        private InventoryMenuTransition[] transitions;

        private PageContext() {
        }

        static /* synthetic */ InventoryMenuPattern[] access$402(PageContext x0, InventoryMenuPattern[] x1) {
            x0.patterns = x1;
            return x1;
        }

        static /* synthetic */ InventoryMenuTransition[] access$202(PageContext x0, InventoryMenuTransition[] x1) {
            x0.transitions = x1;
            return x1;
        }
    }

    private static class Bindable<T> {
        MethodHandle bind;
        T data;

        public Bindable(MethodHandle bind, T data) {
            this.bind = bind;
            this.data = data;
        }

        public void bind(Object instance, Object value) {
            if (this.bind == null) {
                return;
            }
            try {
                this.bind.invoke(instance, value);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static class Invokable<T> {
        private final T data;
        private final MethodHandle method;

        public Invokable(T data, MethodHandle invoke) {
            this.data = data;
            this.method = invoke;
        }
    }
}

