/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.SimpleGoalController;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCCloneEvent;
import net.citizensnpcs.api.event.NPCRemoveByCommandSenderEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRemoveTraitEvent;
import net.citizensnpcs.api.event.NPCRenameEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.RemoveReason;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractNPC
implements NPC {
    protected Object coloredNameComponentCache;
    protected String coloredNameStringCache;
    private final GoalController goalController = new SimpleGoalController();
    private final int id;
    private Supplier<ItemStack> itemProvider = () -> {
        Material id = Material.STONE;
        int data = this.data().get(NPC.Metadata.ITEM_DATA, this.data().get("falling-block-data", Integer.valueOf(0)));
        if (this.data().has(NPC.Metadata.ITEM_ID)) {
            id = Material.getMaterial((String)((String)this.data().get(NPC.Metadata.ITEM_ID)), (boolean)false);
        }
        if (id == Material.AIR) {
            id = Material.STONE;
            Messaging.severe(this.getId(), "invalid Material: converted to stone");
        }
        return new ItemStack(id, this.data().get(NPC.Metadata.ITEM_AMOUNT, Integer.valueOf(1)).intValue(), (short)data);
    };
    private final MetadataStore metadata = new SimpleMetadataStore();
    private String name;
    private final NPCRegistry registry;
    private final List<String> removedTraits = Lists.newArrayList();
    private final List<Runnable> runnables = Lists.newArrayList();
    private final SpeechController speechController = context -> {
        context.setTalker(this.getEntity());
        NPCSpeechEvent event = new NPCSpeechEvent(context);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        CitizensAPI.talk(context);
    };
    protected final Map<Class<? extends Trait>, Trait> traits = Maps.newHashMap();
    private final UUID uuid;

    protected AbstractNPC(UUID uuid, int id, String name, NPCRegistry registry) {
        this.uuid = uuid;
        this.id = id;
        this.registry = registry;
        this.setNameInternal(name);
        CitizensAPI.getTraitFactory().addDefaultTraits(this);
    }

    @Override
    public void addRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            Messaging.severe("Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait.getNPC() == null) {
            trait.linkToNPC(this);
        }
        Class<?> clazz = trait.getClass();
        Trait replaced = this.traits.get(clazz);
        Bukkit.getPluginManager().registerEvents((Listener)trait, CitizensAPI.getPlugin());
        this.traits.put(clazz, trait);
        if (this.isSpawned()) {
            trait.onSpawn();
        }
        if (trait.isRunImplemented()) {
            if (replaced != null) {
                this.runnables.remove(replaced);
            }
            this.runnables.add(trait);
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCAddTraitEvent(this, trait));
    }

    @Override
    public NPC clone() {
        return this.copy();
    }

    @Override
    public NPC copy() {
        NPC copy = this.registry.createNPC(this.getOrAddTrait(MobType.class).getType(), this.getRawName());
        MemoryDataKey key = new MemoryDataKey();
        this.save(key);
        copy.load(key);
        for (Trait trait : copy.getTraits()) {
            trait.onCopy();
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCCloneEvent(this, copy));
        return copy;
    }

    @Override
    public MetadataStore data() {
        return this.metadata;
    }

    @Override
    public boolean despawn() {
        return this.despawn(DespawnReason.PLUGIN);
    }

    @Override
    public void destroy() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove(RemoveReason.DESTROYED);
        }
        this.traits.clear();
        this.goalController.clear();
        this.registry.deregister(this);
    }

    @Override
    public void destroy(CommandSender source) {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveByCommandSenderEvent(this, source));
        this.destroy();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNPC other = (AbstractNPC)obj;
        return Objects.equals(this.uuid, other.uuid);
    }

    @Override
    public GoalController getDefaultGoalController() {
        return this.goalController;
    }

    @Override
    public SpeechController getDefaultSpeechController() {
        return this.speechController;
    }

    protected EntityType getEntityType() {
        return this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
    }

    @Override
    public String getFullName() {
        int nameLength = SpigotUtil.getMaxNameLength(this.getEntityType());
        String replaced = Placeholders.replaceName(this.coloredNameStringCache != null ? this.coloredNameStringCache : Messaging.parseComponents(this.name), null, this);
        if (replaced.length() > nameLength) {
            Messaging.severe("ID", this.id, "created with name length greater than " + nameLength + ", truncating", replaced, "to", replaced.substring(0, nameLength));
            replaced = replaced.substring(0, nameLength);
        }
        return replaced;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Supplier<ItemStack> getItemProvider() {
        return this.itemProvider;
    }

    @Override
    public UUID getMinecraftUniqueId() {
        UUID uuid;
        if (this.getEntityType() == EntityType.PLAYER && (uuid = this.getUniqueId()).version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            return new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        return this.getUniqueId();
    }

    @Override
    public String getName() {
        return ChatColor.stripColor((String)this.coloredNameStringCache);
    }

    @Override
    public <T extends Trait> T getOrAddTrait(Class<T> clazz) {
        Trait trait = this.traits.get(clazz);
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)((Trait)clazz.cast(trait));
    }

    @Override
    public NPCRegistry getOwningRegistry() {
        return this.registry;
    }

    @Override
    public String getRawName() {
        return this.name;
    }

    @Override
    @Deprecated
    public <T extends Trait> T getTrait(Class<T> clazz) {
        return this.getOrAddTrait(clazz);
    }

    protected Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public <T extends Trait> T getTraitNullable(Class<T> clazz) {
        return (T)((Trait)clazz.cast(this.traits.get(clazz)));
    }

    @Override
    public Iterable<Trait> getTraits() {
        return this.traits.values();
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    public int hashCode() {
        return 31 + this.uuid.hashCode();
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public boolean isFlyable() {
        return this.data().get(NPC.Metadata.FLYABLE, Boolean.valueOf(false));
    }

    @Override
    public boolean isHiddenFrom(Player player) {
        PlayerFilter filter = this.getTraitNullable(PlayerFilter.class);
        return filter != null ? filter.isHidden(player) : false;
    }

    @Override
    public boolean isProtected() {
        return this.data().get(NPC.Metadata.DEFAULT_PROTECTED, Boolean.valueOf(true));
    }

    @Override
    public boolean isPushableByFluids() {
        return this.data().get(NPC.Metadata.FLUID_PUSHABLE, Boolean.valueOf(!this.isProtected()));
    }

    @Override
    public void load(DataKey root) {
        this.setNameInternal(root.getString("name"));
        if (root.keyExists("itemprovider")) {
            ItemStack item = ItemStorage.loadItemStack(root.getRelative("itemprovider"));
            this.setItemProvider(() -> item);
        }
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        HashSet keys = Sets.newHashSet(root.getRelative("traits").getSubKeys());
        Iterables.addAll((Collection)keys, (Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)traitNames), input -> root.getRelative("traits." + input)));
        DataKey locationKey = root.getRelative("traits.location");
        if (locationKey.keyExists()) {
            this.loadTraitFromKey(locationKey);
            keys.remove(locationKey);
        }
        for (DataKey key : keys) {
            if (key.name().equals("speech")) continue;
            this.loadTraitFromKey(key);
        }
    }

    private void loadTraitFromKey(DataKey traitKey) {
        Trait trait;
        if (traitKey.name().equals("smoothrotationtrait")) {
            traitKey.removeKey("");
            return;
        }
        Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
        if (this.hasTrait(clazz)) {
            trait = this.getTraitNullable(clazz);
        } else {
            trait = CitizensAPI.getTraitFactory().getTrait(clazz);
            if (trait == null) {
                Messaging.severeTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
                return;
            }
            this.addTrait(trait);
        }
        try {
            PersistenceLoader.load(trait, traitKey);
            trait.load(traitKey);
        }
        catch (Throwable ex) {
            if (Messaging.isDebugging()) {
                ex.printStackTrace();
            }
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> traitClass) {
        Trait trait = this.traits.remove(traitClass);
        if (trait != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCRemoveTraitEvent(this, trait));
            this.removedTraits.add(trait.getName());
            if (trait.isRunImplemented()) {
                this.runnables.remove(trait);
            }
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove(RemoveReason.REMOVAL);
        }
    }

    @Override
    public boolean requiresNameHologram() {
        return this.name.length() > 16 && this.getEntityType() == EntityType.PLAYER || this.data().get(NPC.Metadata.ALWAYS_USE_NAME_HOLOGRAM, Boolean.valueOf(false)) != false || this.coloredNameStringCache != null && this.coloredNameStringCache.contains("\u00a7x") || !Placeholders.replaceName(this.name, null, this).equals(this.name);
    }

    @Override
    public void save(DataKey root) {
        if (!this.metadata.get(NPC.Metadata.SHOULD_SAVE, Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.metadata.saveTo(root.getRelative("metadata"));
        root.setString("name", this.name);
        root.setString("uuid", this.uuid.toString());
        if (this.data().has(NPC.Metadata.ITEM_ID)) {
            ItemStack stack = this.itemProvider.get();
            ItemStorage.saveItem(root.getRelative("itemprovider"), stack);
        } else {
            root.removeKey("itemprovider");
        }
        StringBuilder traitNames = new StringBuilder();
        for (Trait trait : this.traits.values()) {
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            trait.save(traitKey);
            try {
                PersistenceLoader.save(trait, traitKey);
            }
            catch (Throwable t) {
                Messaging.log("PersistenceLoader failed for", trait);
                t.printStackTrace();
                continue;
            }
            this.removedTraits.remove(trait.getName());
            traitNames.append(trait.getName() + ",");
        }
        if (traitNames.length() > 0) {
            root.setString("traitnames", traitNames.substring(0, traitNames.length() - 1));
        } else {
            root.setString("traitnames", "");
        }
        for (String name : this.removedTraits) {
            root.removeKey("traits." + name);
        }
        this.removedTraits.clear();
    }

    @Override
    public void setAlwaysUseNameHologram(boolean use) {
        this.data().setPersistent(NPC.Metadata.ALWAYS_USE_NAME_HOLOGRAM, (Object)use);
    }

    @Override
    public void setFlyable(boolean flyable) {
        this.data().setPersistent(NPC.Metadata.FLYABLE, (Object)flyable);
    }

    @Override
    public void setItemProvider(Supplier<ItemStack> provider) {
        this.itemProvider = provider;
        ItemStack stack = provider.get();
        if (stack != null) {
            this.data().set(NPC.Metadata.ITEM_ID, (Object)stack.getType().name());
            this.data().set(NPC.Metadata.ITEM_DATA, (Object)stack.getData().getData());
            this.data().set(NPC.Metadata.ITEM_AMOUNT, (Object)stack.getAmount());
        }
    }

    @Override
    public void setName(String name) {
        if (name.equals(this.name)) {
            return;
        }
        NPCRenameEvent event = new NPCRenameEvent(this, this.name, name);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.setNameInternal(event.getNewName());
        if (!this.isSpawned()) {
            return;
        }
        Entity bukkitEntity = this.getEntity();
        this.updateCustomName();
        if (bukkitEntity.getType() == EntityType.PLAYER && !this.requiresNameHologram()) {
            Location old = bukkitEntity.getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
            this.spawn(old);
        }
    }

    private void setNameInternal(String name) {
        this.name = name;
        this.coloredNameComponentCache = Messaging.minecraftComponentFromRawMessage(this.name);
        this.coloredNameStringCache = Messaging.parseComponents(this.name);
    }

    @Override
    public void setProtected(boolean isProtected) {
        this.data().setPersistent(NPC.Metadata.DEFAULT_PROTECTED, (Object)isProtected);
    }

    @Override
    public void setUseMinecraftAI(boolean use) {
        this.data().setPersistent(NPC.Metadata.USE_MINECRAFT_AI, (Object)use);
    }

    private void teleport(Entity entity, Location location, int delay, PlayerTeleportEvent.TeleportCause cause) {
        Entity passenger = entity.getPassenger();
        entity.eject();
        if (!location.getWorld().equals(entity.getWorld())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> entity.teleport(location, cause), (long)delay++);
        } else {
            entity.teleport(location, cause);
        }
        if (passenger == null) {
            return;
        }
        this.teleport(passenger, location, delay++, cause);
        Runnable task = () -> entity.setPassenger(passenger);
        if (!location.getWorld().equals(entity.getWorld())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), task, (long)delay);
        } else {
            task.run();
        }
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (!this.isSpawned()) {
            return;
        }
        NPCTeleportEvent event = new NPCTeleportEvent(this, location);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Entity entity = this.getEntity();
        while (entity.getVehicle() != null) {
            entity = entity.getVehicle();
        }
        location.getBlock().getChunk();
        this.teleport(entity, location, 5, cause);
    }

    protected void unloadEvents() {
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
        }
        this.traits.clear();
        this.goalController.clear();
    }

    public void update() {
        for (int i = 0; i < this.runnables.size(); ++i) {
            this.runnables.get(i).run();
        }
        if (this.isSpawned()) {
            this.goalController.run();
        }
    }

    @Override
    public void updateCustomName() {
        this.getEntity().setCustomName(this.getFullName());
    }

    @Override
    public boolean useMinecraftAI() {
        return this.data().get(NPC.Metadata.USE_MINECRAFT_AI, Boolean.valueOf(false));
    }
}

