/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.SlotSource;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.inventory.Inventory;

public class MenuContext
implements SlotSource {
    private final Map<String, Object> data = Maps.newHashMap();
    private final Inventory inventory;
    private final InventoryMenu menu;
    private final InventoryMenuSlot[] slots;
    private String title;

    public MenuContext(InventoryMenu menu, InventoryMenuSlot[] slots, Inventory inventory, String title) {
        this(menu, slots, inventory, title, Collections.emptyMap());
    }

    public MenuContext(InventoryMenu menu, InventoryMenuSlot[] slots, Inventory inventory, String title, Map<String, Object> data) {
        this.inventory = inventory;
        this.title = title;
        this.slots = slots;
        this.menu = menu;
        this.data.putAll(data);
    }

    public void clearSlots() {
        for (int i = 0; i < this.slots.length; ++i) {
            InventoryMenuSlot slot = this.slots[i];
            if (slot != null) {
                slot.clear();
            }
            this.slots[i] = null;
        }
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public InventoryMenu getMenu() {
        return this.menu;
    }

    @Override
    public InventoryMenuSlot getSlot(int i) {
        if (this.slots[i] == null) {
            this.slots[i] = new InventoryMenuSlot(this, i);
            return this.slots[i];
        }
        return this.slots[i];
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = Messaging.parseComponents(title);
        this.menu.updateTitle(title);
    }
}

