/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.CommandEventAction;
import net.citizensnpcs.api.npc.templates.CommandListExecutor;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.npc.templates.YamlReplacementAction;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;

public class Template {
    private final List<Consumer<NPC>> actions = Lists.newArrayList();
    private final String name;
    private final String namespace;

    private Template(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    private void addAction(Consumer<NPC> action) {
        this.actions.add(action);
    }

    public void apply(NPC npc) {
        boolean respawn = npc.isSpawned();
        if (respawn) {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
        }
        for (Consumer<NPC> action : this.actions) {
            action.accept(npc);
        }
        if (respawn) {
            npc.spawn(npc.getStoredLocation());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static Template load(TemplateWorkspace workspace, String namespace, DataKey key) {
        Template template = new Template(namespace, key.name());
        if (key.keyExists("yaml_replace")) {
            template.addAction((Consumer)((Object)PersistenceLoader.load(YamlReplacementAction.class, key.getRelative("yaml_replace"))));
        }
        if (key.keyExists("commands")) {
            Template.loadCommands(template, workspace, key.getRelative("commands"));
        }
        return template;
    }

    private static void loadCommands(Template template, TemplateWorkspace workspace, DataKey key) {
        for (DataKey sub : key.getSubKeys()) {
            if (!sub.name().equals("on_spawn")) continue;
            template.addAction(new CommandEventAction(NPCSpawnEvent.class, new CommandListExecutor((List)key.getRaw(""))));
        }
    }
}

