/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;

public class YamlReplacementAction
implements Consumer<NPC> {
    private final boolean override;
    private final Map<String, Object> replacements;

    @DelegatePersistence(value=YRAPersister.class)
    private YamlReplacementAction(boolean override, Map<String, Object> replacements) {
        this.replacements = replacements;
        this.override = override;
    }

    @Override
    public void accept(NPC npc) {
        MemoryDataKey memoryKey = new MemoryDataKey();
        npc.save(memoryKey);
        ArrayList queue = Lists.newArrayList((Object[])new Node[]{new Node("", this.replacements)});
        for (int i = 0; i < queue.size(); ++i) {
            Node node = (Node)queue.get(i);
            for (Map.Entry<String, Object> entry : node.map.entrySet()) {
                String fullKey;
                String string = fullKey = node.headKey.isEmpty() ? entry.getKey() : node.headKey + '.' + entry.getKey();
                if (entry.getValue() instanceof Map) {
                    queue.add(new Node(fullKey, (Map)entry.getValue()));
                    continue;
                }
                boolean overwrite = memoryKey.keyExists(fullKey) || this.override;
                if (!overwrite || fullKey.equals("uuid")) continue;
                memoryKey.setRaw(fullKey, entry.getValue());
            }
        }
        npc.load(memoryKey);
    }

    private static class Node {
        String headKey;
        Map<String, Object> map;

        private Node(String headKey, Map<String, Object> map) {
            this.headKey = headKey;
            this.map = map;
        }
    }

    private static class YRAPersister
    implements Persister<YamlReplacementAction> {
        @Override
        public YamlReplacementAction create(DataKey root) {
            return new YamlReplacementAction(root.getBoolean("override"), root.getRelative("replacements").getValuesDeep());
        }

        @Override
        public void save(YamlReplacementAction instance, DataKey root) {
            root.setBoolean("override", instance.override);
            root.setRaw("replacements", instance.replacements);
        }
    }
}

