/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;

public final class TraitInfo {
    private boolean defaultTrait;
    private String name;
    private Supplier<? extends Trait> supplier;
    private boolean trackStats;
    private final Class<? extends Trait> trait;
    private boolean triedAnnotation;

    private TraitInfo(Class<? extends Trait> trait) {
        this.trait = trait;
    }

    public TraitInfo asDefaultTrait() {
        this.defaultTrait = true;
        return this;
    }

    public void checkValid() {
        if (this.supplier == null) {
            try {
                this.trait.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Trait class must have a no-arguments constructor");
            }
        }
    }

    public Class<? extends Trait> getTraitClass() {
        return this.trait;
    }

    public String getTraitName() {
        if (this.name == null && !this.triedAnnotation) {
            TraitName anno = this.trait.getAnnotation(TraitName.class);
            if (anno != null) {
                this.name = anno.value().toLowerCase(Locale.US);
            }
            this.triedAnnotation = true;
        }
        return this.name;
    }

    public boolean isDefaultTrait() {
        return this.defaultTrait;
    }

    public TraitInfo optInToStats() {
        this.trackStats = true;
        return this;
    }

    public boolean trackStats() {
        return this.trackStats;
    }

    public <T extends Trait> T tryCreateInstance() {
        if (this.supplier != null) {
            return (T)this.supplier.get();
        }
        try {
            return (T)this.trait.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public TraitInfo withName(String name) {
        Objects.requireNonNull(name);
        this.name = name.toLowerCase(Locale.US);
        return this;
    }

    public TraitInfo withSupplier(Supplier<? extends Trait> supplier) {
        this.supplier = supplier;
        return this;
    }

    public static TraitInfo create(Class<? extends Trait> trait) {
        Objects.requireNonNull(trait);
        return new TraitInfo(trait);
    }
}

