/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Listener;

public class WanderGoal
extends BehaviorGoalAdapter
implements Listener {
    private int delay;
    private int delayedTicks;
    private Function<Block, Boolean> filter;
    private boolean forceFinish;
    private int movingTicks;
    private final NPC npc;
    private boolean pathfind;
    private boolean paused;
    private final Function<NPC, Location> picker;
    private Location target;
    private final Supplier<PhTreeSolid<Boolean>> tree;
    private final Supplier<Object> worldguardRegion;
    private int xrange;
    private int yrange;
    private static final Random RANDOM = new Random();

    private WanderGoal(NPC npc, boolean pathfind, int xrange, int yrange, Supplier<PhTreeSolid<Boolean>> tree, Supplier<Object> worldguardRegion, int delay, Function<Block, Boolean> filter, Function<NPC, Location> picker) {
        this.npc = npc;
        this.pathfind = pathfind;
        this.worldguardRegion = worldguardRegion;
        this.xrange = xrange;
        this.yrange = yrange;
        this.tree = tree;
        this.delay = delay;
        this.picker = picker;
        this.filter = filter == null ? block -> {
            Object region;
            if ((MinecraftBlockExaminer.isLiquidOrInLiquid(block.getRelative(BlockFace.UP)) || MinecraftBlockExaminer.isLiquidOrInLiquid(block.getRelative(0, 2, 0))) && npc.getNavigator().getDefaultParameters().avoidWater()) {
                return false;
            }
            if (worldguardRegion != null && (region = worldguardRegion.get()) != null) {
                try {
                    if (!((ProtectedRegion)region).contains(BukkitAdapter.asBlockVector((Location)block.getLocation()))) {
                        return false;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (tree != null) {
                long[] pt = new long[]{block.getX(), block.getY(), block.getZ()};
                if (tree.get() != null && !((PhTreeSolid)tree.get()).queryIntersect(pt, pt).hasNext()) {
                    return false;
                }
            }
            return true;
        } : filter;
    }

    private Location findRandomPosition() {
        if (this.picker != null) {
            return this.picker.apply(this.npc);
        }
        return MinecraftBlockExaminer.findRandomValidLocation(this.npc.getStoredLocation(), this.pathfind ? this.xrange : 1, this.pathfind ? this.yrange : 1, this.filter, RANDOM);
    }

    public void pause() {
        this.paused = true;
        if (this.target != null) {
            if (this.pathfind) {
                this.npc.getNavigator().cancelNavigation();
            } else {
                this.npc.setMoveDestination(null);
            }
        }
    }

    @Override
    public void reset() {
        this.target = null;
        this.movingTicks = 0;
        this.delayedTicks = this.delay;
        this.forceFinish = false;
    }

    @Override
    public BehaviorStatus run() {
        if (this.paused || this.forceFinish) {
            return BehaviorStatus.SUCCESS;
        }
        if (this.pathfind) {
            if (!this.npc.getNavigator().isNavigating()) {
                return BehaviorStatus.SUCCESS;
            }
        } else {
            if (!(this.npc.getEntity().getLocation().distance(this.target) >= 0.1)) {
                return BehaviorStatus.SUCCESS;
            }
            this.npc.setMoveDestination(this.target);
            if (this.movingTicks-- <= 0) {
                this.npc.setMoveDestination(null);
                return BehaviorStatus.SUCCESS;
            }
        }
        return BehaviorStatus.RUNNING;
    }

    public void setDelay(int delayTicks) {
        this.delay = delayTicks;
        this.delayedTicks = delayTicks;
        this.forceFinish = true;
    }

    public void setPathfind(boolean pathfind) {
        this.pathfind = pathfind;
        this.forceFinish = true;
    }

    public void setXYRange(int xrange, int yrange) {
        this.xrange = xrange;
        this.yrange = yrange;
        this.forceFinish = true;
    }

    @Override
    public boolean shouldExecute() {
        if (!this.npc.isSpawned() || this.npc.getNavigator().isNavigating() || this.paused || this.delayedTicks-- > 0) {
            return false;
        }
        Location dest = this.findRandomPosition();
        if (dest == null) {
            return false;
        }
        if (this.pathfind) {
            this.npc.getNavigator().setTarget(dest);
            this.npc.getNavigator().getLocalParameters().stuckAction(null);
            this.npc.getNavigator().getLocalParameters().addSingleUseCallback(reason -> {
                this.forceFinish = true;
            });
        } else {
            Random random = new Random();
            dest.setX(dest.getX() + random.nextDouble() * 0.5);
            dest.setZ(dest.getZ() + random.nextDouble() * 0.5);
            this.movingTicks = 20 + random.nextInt(20);
        }
        this.target = dest;
        return true;
    }

    public void unpause() {
        this.paused = false;
    }

    public static Builder builder(NPC npc) {
        return new Builder(npc);
    }

    public static class Builder {
        private int delay = 10;
        private Function<Block, Boolean> filter;
        private final NPC npc;
        private boolean pathfind = true;
        private Function<NPC, Location> picker;
        private Supplier<PhTreeSolid<Boolean>> tree;
        private Supplier<Object> worldguardRegion;
        private int xrange = 10;
        private int yrange = 2;

        private Builder(NPC npc) {
            this.npc = npc;
        }

        public WanderGoal build() {
            return new WanderGoal(this.npc, this.pathfind, this.xrange, this.yrange, this.tree, this.worldguardRegion, this.delay, this.filter, this.picker);
        }

        public Builder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public Builder destinationPicker(Function<NPC, Location> picker) {
            this.picker = picker;
            return this;
        }

        public Builder filter(Function<Block, Boolean> filter) {
            this.filter = filter;
            return this;
        }

        public Builder pathfind(boolean pathfind) {
            this.pathfind = pathfind;
            return this;
        }

        public Builder regionCentres(Supplier<Iterable<Location>> supplier) {
            this.tree = () -> {
                PhTreeSolid tree = PhTreeSolid.create((int)3);
                for (Location loc : (Iterable)supplier.get()) {
                    long[] lower = new long[]{loc.getBlockX() - this.xrange, loc.getBlockY() - this.yrange, loc.getBlockZ() - this.xrange};
                    long[] upper = new long[]{loc.getBlockX() + this.xrange, loc.getBlockY() + this.yrange, loc.getBlockZ() + this.xrange};
                    tree.put(lower, upper, (Object)true);
                }
                return tree;
            };
            return this;
        }

        public Builder tree(Supplier<PhTreeSolid<Boolean>> supplier) {
            this.tree = supplier;
            return this;
        }

        public Builder worldguardRegion(Supplier<Object> worldguardRegion) {
            this.worldguardRegion = worldguardRegion;
            return this;
        }

        public Builder xrange(int xrange) {
            this.xrange = xrange;
            return this;
        }

        public Builder yrange(int yrange) {
            this.yrange = yrange;
            return this;
        }
    }
}

