/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class SpigotUtil {
    private static int[] BUKKIT_VERSION = null;
    private static Pattern DAY_MATCHER = Pattern.compile("(\\d+d)");
    private static String MINECRAFT_PACKAGE;
    private static Pattern NUMBER_MATCHER;
    private static boolean SUPPORT_WORLD_HEIGHT;
    private static Boolean using1_13API;

    public static boolean checkYSafe(double y, World world) {
        if (!SUPPORT_WORLD_HEIGHT || world == null) {
            return y >= 0.0 && y <= 255.0;
        }
        try {
            return y >= (double)world.getMinHeight() && y <= (double)world.getMaxHeight();
        }
        catch (Throwable t) {
            SUPPORT_WORLD_HEIGHT = false;
            return y >= 0.0 && y <= 255.0;
        }
    }

    public static int getMaxNameLength(EntityType type) {
        return SpigotUtil.isUsing1_13API() ? 256 : 64;
    }

    public static String getMinecraftPackage() {
        if (MINECRAFT_PACKAGE == null) {
            int[] version = SpigotUtil.getVersion();
            if (version == null) {
                throw new IllegalStateException();
            }
            String versionString = "v" + version[0] + "_" + version[1] + "_R";
            ThrowingConsumer<String> versionChecker = s -> Class.forName("org.bukkit.craftbukkit." + s + ".CraftServer");
            if (Bukkit.getServer().getClass().getName().equals("org.bukkit.craftbukkit.CraftServer")) {
                Messaging.log("Using mojmapped server, avoiding server package checks");
                versionChecker = s -> Class.forName("net.citizensnpcs.nms." + s + ".util.NMSImpl");
            }
            String revision = null;
            for (int i = 1; i <= 4; ++i) {
                try {
                    versionChecker.accept(versionString + i);
                    revision = versionString + i;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
            if (revision == null) {
                throw new IllegalStateException();
            }
            MINECRAFT_PACKAGE = revision;
        }
        return MINECRAFT_PACKAGE;
    }

    public static int[] getVersion() {
        if (BUKKIT_VERSION == null) {
            String version = Bukkit.getBukkitVersion();
            if (version == null || version.isEmpty()) {
                BUKKIT_VERSION = new int[]{1, 8, 8};
                return BUKKIT_VERSION;
            }
            String[] parts = version.split("\\.");
            if (parts[1].contains("-")) {
                parts[1] = parts[1].split("-")[0];
            }
            if (parts[2].contains("-")) {
                parts[2] = parts[2].split("-")[0];
            }
            if (parts.length == 3) {
                BUKKIT_VERSION = new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])};
                return BUKKIT_VERSION;
            }
            BUKKIT_VERSION = new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
            return BUKKIT_VERSION;
        }
        return BUKKIT_VERSION;
    }

    public static boolean isUsing1_13API() {
        if (using1_13API == null) {
            try {
                Enchantment.getByKey((NamespacedKey)Enchantment.getByName((String)"ARROW_DAMAGE").getKey());
                using1_13API = true;
            }
            catch (Exception ex) {
                using1_13API = false;
            }
            catch (NoSuchMethodError ex) {
                using1_13API = false;
            }
        }
        return using1_13API;
    }

    public static Duration parseDuration(String raw, TimeUnit defaultUnits) {
        if (defaultUnits == null) {
            Integer ticks = Ints.tryParse((String)raw);
            if (ticks != null) {
                return Duration.ofMillis(ticks * 50);
            }
        } else if (NUMBER_MATCHER.matcher(raw).matches()) {
            return Duration.of(Longs.tryParse((String)raw), SpigotUtil.toChronoUnit(defaultUnits));
        }
        if (raw.endsWith("t")) {
            return Duration.ofMillis(Integer.parseInt(raw.substring(0, raw.length() - 1)) * 50);
        }
        if ((raw = DAY_MATCHER.matcher(raw).replaceFirst("P$1").replace("min", "m").replace("hr", "h")).charAt(0) != 'P') {
            raw = "PT" + raw;
        }
        return Duration.parse(raw);
    }

    private static ChronoUnit toChronoUnit(TimeUnit tu) {
        switch (tu) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    static {
        NUMBER_MATCHER = Pattern.compile("(\\d+)");
        SUPPORT_WORLD_HEIGHT = true;
    }

    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws ClassNotFoundException;
    }

    public static class InventoryViewAPI {
        private final InventoryView view;
        private static final MethodHandle CLOSE = InventoryViewAPI.getMethod(InventoryView.class, "close", new Class[0]);
        private static final MethodHandle EQUALS = InventoryViewAPI.getMethod(Object.class, "equals", Object.class);
        private static final MethodHandle GET_PLAYER = InventoryViewAPI.getMethod(InventoryView.class, "getPlayer", new Class[0]);
        private static final MethodHandle HASHCODE = InventoryViewAPI.getMethod(Object.class, "hashCode", new Class[0]);
        private static final MethodHandle TOP_INVENTORY = InventoryViewAPI.getMethod(InventoryView.class, "getTopInventory", new Class[0]);

        public InventoryViewAPI(InventoryView view) {
            this.view = view;
        }

        public void close() {
            try {
                CLOSE.invoke(this.view);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public boolean equals(Object obj) {
            if (this == obj || obj == null) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InventoryViewAPI other = (InventoryViewAPI)obj;
            if (this.view == null) {
                if (other.view != null) {
                    return false;
                }
            } else {
                try {
                    if (!EQUALS.invoke(this.view, other.view)) {
                        return false;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        public Player getPlayer() {
            try {
                return GET_PLAYER.invoke(this.view);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        public Inventory getTopInventory() {
            try {
                return TOP_INVENTORY.invoke(this.view);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        public InventoryView getView() {
            return this.view;
        }

        public int hashCode() {
            try {
                return 31 + (this.view == null ? 0 : HASHCODE.invoke(this.view));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 31;
            }
        }

        private static MethodHandle getMethod(Class<?> clazz, String method, Class<?> ... params) {
            try {
                Method f = null;
                try {
                    f = clazz.getMethod(method, params);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return MethodHandles.publicLookup().unreflect(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

