/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.DataKey;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public interface NPC
extends Agent,
Cloneable {
    public void addRunnable(Runnable var1);

    public void addTrait(Class<? extends Trait> var1);

    public void addTrait(Trait var1);

    public NPC clone();

    public NPC copy();

    public MetadataStore data();

    public boolean despawn();

    public boolean despawn(DespawnReason var1);

    public void destroy();

    public void destroy(CommandSender var1);

    public void faceLocation(Location var1);

    public BlockBreaker getBlockBreaker(Block var1, BlockBreaker.BlockBreakerConfiguration var2);

    public GoalController getDefaultGoalController();

    public SpeechController getDefaultSpeechController();

    public Entity getEntity();

    public String getFullName();

    public int getId();

    public Supplier<ItemStack> getItemProvider();

    public UUID getMinecraftUniqueId();

    public String getName();

    public Navigator getNavigator();

    public <T extends Trait> T getOrAddTrait(Class<T> var1);

    public NPCRegistry getOwningRegistry();

    public String getRawName();

    public Location getStoredLocation();

    @Deprecated
    public <T extends Trait> T getTrait(Class<T> var1);

    public <T extends Trait> T getTraitNullable(Class<T> var1);

    default public <T extends Trait> Optional<T> getTraitOptional(Class<T> trait) {
        return Optional.fromNullable(this.getTraitNullable(trait));
    }

    public Iterable<Trait> getTraits();

    public UUID getUniqueId();

    public boolean hasTrait(Class<? extends Trait> var1);

    public boolean isFlyable();

    public boolean isHiddenFrom(Player var1);

    public boolean isProtected();

    public boolean isPushableByFluids();

    public boolean isSpawned();

    public boolean isUpdating(NPCUpdate var1);

    public void load(DataKey var1);

    public void removeTrait(Class<? extends Trait> var1);

    public boolean requiresNameHologram();

    public void save(DataKey var1);

    public void scheduleUpdate(NPCUpdate var1);

    public void setAlwaysUseNameHologram(boolean var1);

    public void setBukkitEntityType(EntityType var1);

    public void setFlyable(boolean var1);

    public void setItemProvider(Supplier<ItemStack> var1);

    public void setMoveDestination(Location var1);

    public void setName(String var1);

    public void setProtected(boolean var1);

    public void setSneaking(boolean var1);

    public void setUseMinecraftAI(boolean var1);

    public boolean shouldRemoveFromTabList();

    public boolean spawn(Location var1);

    public boolean spawn(Location var1, SpawnReason var2);

    public void teleport(Location var1, PlayerTeleportEvent.TeleportCause var2);

    public boolean useMinecraftAI();

    public static enum NPCUpdate {
        PACKET;

    }

    public static enum Metadata {
        ACTIVATION_RANGE("activation-range", Integer.class),
        AGGRESSIVE("entity-aggressive", Boolean.class),
        ALWAYS_USE_NAME_HOLOGRAM("always-use-name-hologram", Boolean.class),
        AMBIENT_SOUND("ambient-sound", String.class),
        BOUNDING_BOX_FUNCTION("bounding-box-function", new TypeToken<Supplier<BoundingBox>>(){}),
        COLLIDABLE("collidable", Boolean.class),
        DAMAGE_OTHERS("damage-others", Boolean.class),
        DEATH_SOUND("death-sound", String.class),
        DEFAULT_PROTECTED("protected", Boolean.class),
        DISABLE_DEFAULT_STUCK_ACTION("disable-default-stuck-action", Boolean.class),
        DROPS_ITEMS("drops-items", Boolean.class),
        FLUID_PUSHABLE("fluid-pushable", Boolean.class),
        FLYABLE("flyable", Boolean.class),
        FORCE_PACKET_UPDATE("force-packet-update", Boolean.class),
        GLOWING("glowing", Boolean.class),
        HOLOGRAM_RENDERER("hologram-renderer", Object.class),
        HURT_SOUND("hurt-sound", String.class),
        ITEM_AMOUNT("item-type-amount", Integer.class),
        ITEM_DATA("item-type-data", Byte.class),
        ITEM_ID("item-type-id", String.class),
        JUMP_POWER_SUPPLIER("jump-power-supplier", new TypeToken<Function<NPC, Float>>(){}),
        KEEP_CHUNK_LOADED("keep-chunk-loaded", Boolean.class),
        KNOCKBACK("knockback", Boolean.class),
        LEASH_PROTECTED("protected-leash", Boolean.class),
        MINECART_ITEM("minecart-item-name", String.class),
        MINECART_ITEM_DATA("minecart-item-data", Byte.class),
        MINECART_OFFSET("minecart-item-offset", Integer.class),
        NAMEPLATE_VISIBLE("nameplate-visible", Boolean.class),
        PACKET_UPDATE_DELAY("packet-update-delay", Integer.class),
        PATHFINDER_FALL_DISTANCE("pathfinder-fall-distance", Double.class),
        PATHFINDER_OPEN_DOORS("pathfinder-open-doors", Boolean.class),
        PICKUP_ITEMS("pickup-items", Boolean.class),
        REMOVE_FROM_PLAYERLIST("removefromplayerlist", Boolean.class),
        REMOVE_FROM_TABLIST("removefromtablist", Boolean.class),
        RESET_PITCH_ON_TICK("reset-pitch-on-tick", Boolean.class),
        RESET_YAW_ON_SPAWN("reset-yaw-on-spawn", Boolean.class),
        RESPAWN_DELAY("respawn-delay", Integer.class),
        SCOREBOARD_FAKE_TEAM_NAME("fake-scoreboard-team-name", String.class),
        SHOULD_SAVE("should-save", Boolean.class),
        SILENT("silent-sounds", Boolean.class),
        SPAWN_NODAMAGE_TICKS("spawn-nodamage-ticks", Integer.class),
        SWIM("swim", Boolean.class),
        TARGETABLE("protected-target", Boolean.class),
        TEXT_DISPLAY_COMPONENT("text-display-component", Component.class),
        TRACKING_RANGE("tracking-distance", Integer.class),
        USE_MINECRAFT_AI("minecraft-ai", Boolean.class),
        USING_HELD_ITEM("using-held-item", Boolean.class),
        USING_OFFHAND_ITEM("using-offhand-item", Boolean.class),
        VILLAGER_BLOCK_TRADES("villager-trades", Boolean.class),
        WATER_SPEED_MODIFIER("water-speed-modifier", Double.class);

        private final String key;
        private final TypeToken<?> type;

        private Metadata(String key, Class<?> type) {
            this(key, TypeToken.of(type));
        }

        private Metadata(String key, TypeToken<?> type) {
            this.key = key;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public TypeToken<?> getType() {
            return this.type;
        }

        public static Metadata byKey(String name) {
            for (Metadata v : Metadata.values()) {
                if (!v.key.equals(name)) continue;
                return v;
            }
            return null;
        }

        public static Metadata byName(String name) {
            try {
                return Metadata.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }
}

