/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.Template;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.YamlStorage;
import org.bukkit.NamespacedKey;

public class TemplateRegistry {
    private final Path baseFolder;
    private final Map<NamespacedKey, Template> fullyQualifiedTemplates = Maps.newHashMap();
    private final Multimap<String, Template> templatesByName = HashMultimap.create();

    public TemplateRegistry(Path folder) {
        this.baseFolder = folder;
        if (!folder.toFile().exists()) {
            folder.toFile().mkdir();
        }
        this.loadTemplates(this.baseFolder);
    }

    public void generateTemplateFromNPC(NamespacedKey key, NPC npc) {
        String namespace = key.getNamespace();
        String file = "templates.yml";
        File namespaceFolder = new File(this.baseFolder.toFile(), namespace);
        namespaceFolder.mkdirs();
        File generatedFile = new File(namespaceFolder, file);
        YamlStorage templateStorage = new YamlStorage(generatedFile);
        if (!templateStorage.load()) {
            throw new IllegalStateException();
        }
        DataKey root = templateStorage.getKey(key.getKey());
        npc.save(root.getRelative("yaml_replace.replacements"));
        root.setBoolean("yaml_replace.override", true);
        root.removeKey("yaml_replace.replacements.uuid");
        templateStorage.save();
        try {
            this.fullyQualifiedTemplates.remove(key);
            this.loadTemplatesFromYamlFile(namespace, generatedFile);
        }
        catch (TemplateLoadException e) {
            e.printStackTrace();
        }
    }

    public Collection<Template> getAllTemplates() {
        return this.fullyQualifiedTemplates.values();
    }

    public Template getTemplateByKey(NamespacedKey key) {
        return this.fullyQualifiedTemplates.get(key);
    }

    public Collection<Template> getTemplates(String name) {
        return this.templatesByName.get((Object)name);
    }

    public boolean hasNamespace(String namespace) {
        for (NamespacedKey key : this.fullyQualifiedTemplates.keySet()) {
            if (!key.getNamespace().equals(namespace)) continue;
            return true;
        }
        return false;
    }

    private void loadTemplate(File folder, String namespace, DataKey key) throws TemplateLoadException {
        NamespacedKey namespacedKey = new NamespacedKey(namespace, key.name().toLowerCase(Locale.ROOT));
        if (this.fullyQualifiedTemplates.containsKey(namespacedKey)) {
            throw new TemplateLoadException("Duplicate template key " + namespacedKey);
        }
        Template template = Template.load(new TemplateWorkspace(folder), namespacedKey, key);
        this.fullyQualifiedTemplates.put(namespacedKey, template);
        this.templatesByName.put((Object)namespacedKey.getKey(), (Object)template);
    }

    private void loadTemplates(Path folder) {
        try {
            Files.walk(folder, 1, new FileVisitOption[0]).forEach(path -> {
                File namespaceFile = path.toFile();
                if (namespaceFile.isFile() && namespaceFile.getName().endsWith(".yml")) {
                    try {
                        this.migrateOldTemplate(folder.toFile(), namespaceFile);
                    }
                    catch (TemplateLoadException e) {
                        Messaging.severe("Error migrating " + namespaceFile.getName() + ": " + e.getMessage());
                    }
                }
            });
            Files.walk(folder, 1, new FileVisitOption[0]).forEach(namespacePath -> {
                File namespaceFile = namespacePath.toFile();
                if (namespaceFile.isDirectory() && !namespaceFile.getName().contains(":")) {
                    try {
                        Files.walk(namespacePath, 1, new FileVisitOption[0]).forEach(templatePath -> {
                            File templateFile = templatePath.toFile();
                            if (templateFile.isFile() && templateFile.getName().endsWith(".yml")) {
                                try {
                                    this.loadTemplatesFromYamlFile(namespaceFile.getName(), templateFile);
                                }
                                catch (TemplateLoadException e) {
                                    Messaging.severe("Error loading " + templateFile.getName() + ": " + e.getMessage());
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            Messaging.log("Loaded", this.fullyQualifiedTemplates.size(), "templates.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadTemplatesFromYamlFile(String namespace, File file) throws TemplateLoadException {
        YamlStorage storage = new YamlStorage(file);
        if (!storage.load()) {
            throw new TemplateLoadException("Unable to load " + file.getName());
        }
        DataKey root = storage.getKey("");
        for (DataKey templateKey : root.getSubKeys()) {
            this.loadTemplate(file.getParentFile(), namespace, templateKey);
        }
    }

    private void migrateOldTemplate(File folder, File template) throws TemplateLoadException {
        Messaging.log("Migrating template", template.getName());
        YamlStorage storage = new YamlStorage(template);
        if (!storage.load()) {
            throw new TemplateLoadException("Unable to migrate " + template.getName());
        }
        File namespaceFolder = new File(folder, "migrated");
        if (!namespaceFolder.exists() && !namespaceFolder.mkdir()) {
            throw new TemplateLoadException("Unable to create destination folder while migrating " + template.getName());
        }
        String templateName = template.getName().replace(".yml", "");
        YamlStorage destination = new YamlStorage(new File(namespaceFolder, template.getName()));
        DataKey from = storage.getKey("");
        DataKey dest = destination.getKey(templateName + ".yaml_replace");
        dest.setBoolean("override", from.getBoolean("override"));
        dest.setRaw("replacements", from.getRelative("replacements").getValuesDeep());
        destination.save();
        template.renameTo(new File(folder, template.getName() + ".migrated"));
    }

    private static class TemplateLoadException
    extends Exception {
        public TemplateLoadException(String string) {
            super(string);
        }
    }
}

