/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.FileStorage;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements FileStorage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;
    private static Field LOADER_OPTIONS;
    private static Method SET_CODEPOINT_LIMIT;

    public YamlStorage(File file) {
        this(file, null);
    }

    public YamlStorage(File file, String header) {
        this.tryIncreaseMaxCodepoints(this.config);
        this.file = file;
        if (!file.exists()) {
            this.create();
            if (header != null) {
                this.config.options().header(header);
            }
            this.save();
        }
    }

    private void create() {
        try {
            Messaging.debug("Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Messaging.severe("Could not create file: " + this.file.getName());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlStorage other = (YamlStorage)obj;
        return Objects.equals(this.file, other.file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public DataKey getKey(String root) {
        return new MemoryDataKey((ConfigurationSection)this.config, root);
    }

    public int hashCode() {
        return 31 + (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean load() {
        try {
            this.config.load(this.file);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void save() {
        try {
            Files.createParentDirs((File)this.file);
            File temporaryFile = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            temporaryFile.deleteOnExit();
            this.config.save(temporaryFile);
            this.file.delete();
            temporaryFile.renameTo(this.file);
            temporaryFile.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    private void tryIncreaseMaxCodepoints(FileConfiguration config) {
        if (SET_CODEPOINT_LIMIT == null || LOADER_OPTIONS == null) {
            return;
        }
        try {
            SET_CODEPOINT_LIMIT.invoke(LOADER_OPTIONS.get(config), 0x4000000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            LOADER_OPTIONS = YamlConfiguration.class.getDeclaredField("yamlLoaderOptions");
            LOADER_OPTIONS.setAccessible(true);
            SET_CODEPOINT_LIMIT = Class.forName("org.yaml.snakeyaml.LoaderOptions").getMethod("setCodepointLimit", Integer.TYPE);
            SET_CODEPOINT_LIMIT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

