/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import ch.ethz.globis.phtree.PhTreeF;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class LocationLookup
extends BukkitRunnable {
    private final Map<String, PerPlayerMetadata<?>> metadata = Maps.newHashMap();
    private Future<Map<UUID, PhTreeF<NPC>>> npcFuture = null;
    private Map<UUID, PhTreeF<NPC>> npcWorlds = Maps.newHashMap();
    private Future<Map<UUID, PhTreeF<Player>>> playerFuture = null;
    private final NPCRegistry sourceRegistry;
    private Map<UUID, PhTreeF<Player>> worlds = Maps.newHashMap();
    private static boolean SUPPORTS_ENTITY_CANSEE = true;

    public LocationLookup() {
        this(CitizensAPI.getNPCRegistry());
    }

    public LocationLookup(NPCRegistry sourceRegistry) {
        this.sourceRegistry = sourceRegistry;
    }

    public PerPlayerMetadata<?> getMetadata(String key) {
        return this.metadata.get(key);
    }

    public Iterable<NPC> getNearbyNPCs(Location base, double dist) {
        PhTreeF<NPC> tree = this.npcWorlds.get(base.getWorld().getUID());
        if (tree == null) {
            return Collections.emptyList();
        }
        return () -> tree.rangeQuery(dist, new double[]{base.getX(), base.getY(), base.getZ()});
    }

    public Iterable<NPC> getNearbyNPCs(NPC npc) {
        return this.getNearbyNPCs(npc.getStoredLocation(), npc.data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(64)).intValue());
    }

    public Iterable<NPC> getNearbyNPCs(World world, double[] min, double[] max) {
        PhTreeF<NPC> tree = this.npcWorlds.get(world.getUID());
        if (tree == null) {
            return Collections.emptyList();
        }
        return () -> tree.query(min, max);
    }

    public Iterable<Player> getNearbyPlayers(Location base, double dist) {
        PhTreeF<Player> tree = this.worlds.get(base.getWorld().getUID());
        if (tree == null) {
            return Collections.emptyList();
        }
        return () -> tree.rangeQuery(dist, new double[]{base.getX(), base.getY(), base.getZ()});
    }

    public Iterable<Player> getNearbyPlayers(NPC npc) {
        return this.getNearbyPlayers(npc.getStoredLocation(), npc.data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(64)).intValue());
    }

    public Iterable<Player> getNearbyPlayers(World base, double[] min, double[] max) {
        PhTreeF<Player> tree = this.worlds.get(base.getUID());
        if (tree == null) {
            return Collections.emptyList();
        }
        return () -> tree.query(min, max);
    }

    public Iterable<Player> getNearbyVisiblePlayers(Entity entity, double range) {
        return this.getNearbyVisiblePlayers(entity, entity.getLocation(), range);
    }

    public Iterable<Player> getNearbyVisiblePlayers(Entity base, double[] min, double[] max) {
        return this.filterToVisiblePlayers(base, this.getNearbyPlayers(base.getWorld(), min, max));
    }

    public Iterable<Player> filterToVisiblePlayers(Entity base, Iterable<Player> players) {
        Player player = base instanceof Player ? (Player)base : null;
        return Iterables.filter(players, other -> {
            boolean canSee = true;
            if (SUPPORTS_ENTITY_CANSEE) {
                try {
                    canSee = other.canSee(base);
                }
                catch (NoSuchMethodError t) {
                    SUPPORTS_ENTITY_CANSEE = false;
                    if (player != null) {
                        canSee = other.canSee(player);
                    }
                }
            } else if (player != null) {
                canSee = other.canSee(player);
            }
            return other.getWorld() == base.getWorld() && canSee && !other.hasPotionEffect(PotionEffectType.INVISIBILITY) && other.getGameMode() != GameMode.SPECTATOR;
        });
    }

    public Iterable<Player> getNearbyVisiblePlayers(Entity base, Location location, double range) {
        return this.filterToVisiblePlayers(base, this.getNearbyPlayers(location, range));
    }

    public void onJoin(PlayerJoinEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.updateWorld(event.getPlayer().getWorld());
            for (PerPlayerMetadata<?> meta : this.metadata.values()) {
                if (((PerPlayerMetadata)meta).onJoin == null) continue;
                ((PerPlayerMetadata)meta).onJoin.accept(meta, event);
            }
        });
    }

    public void onQuit(PlayerQuitEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.updateWorld(event.getPlayer().getWorld());
            for (PerPlayerMetadata<?> meta : this.metadata.values()) {
                ((PerPlayerMetadata)meta).sent.remove(event.getPlayer().getUniqueId());
            }
        });
    }

    public void onWorldUnload(WorldUnloadEvent event) {
        PhTreeF<NPC> npcCache;
        PhTreeF<Player> cache = this.worlds.remove(event.getWorld().getUID());
        if (cache != null) {
            cache.clear();
        }
        if ((npcCache = this.npcWorlds.remove(event.getWorld().getUID())) != null) {
            npcCache.clear();
        }
    }

    public <T> PerPlayerMetadata<T> registerMetadata(String key, BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin) {
        return this.metadata.computeIfAbsent(key, s -> new PerPlayerMetadata(onJoin));
    }

    public void run() {
        Location loc;
        HashMap map;
        if (this.npcFuture != null && this.npcFuture.isDone()) {
            try {
                this.npcWorlds = this.npcFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            this.npcFuture = null;
        }
        if (this.npcFuture == null) {
            map = Maps.newHashMap();
            loc = new Location(null, 0.0, 0.0, 0.0);
            for (NPC npc : this.sourceRegistry) {
                if (!npc.isSpawned()) continue;
                npc.getEntity().getLocation(loc);
                Collection nodes = map.computeIfAbsent(npc.getEntity().getWorld().getUID(), uid -> Lists.newArrayList());
                nodes.add(new TreeFactory.Node<NPC>(new double[]{loc.getX(), loc.getY(), loc.getZ()}, npc));
            }
            this.npcFuture = ForkJoinPool.commonPool().submit((Callable)new TreeFactory(map));
        }
        if (this.playerFuture != null && this.playerFuture.isDone()) {
            try {
                this.worlds = this.playerFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            this.playerFuture = null;
        }
        if (this.playerFuture == null) {
            map = Maps.newHashMap();
            loc = new Location(null, 0.0, 0.0, 0.0);
            for (World world : Bukkit.getServer().getWorlds()) {
                Collection players = Collections2.filter((Collection)world.getPlayers(), p -> !p.hasMetadata("NPC"));
                if (players.isEmpty()) continue;
                map.put(world.getUID(), Collections2.transform((Collection)players, p -> {
                    p.getLocation(loc);
                    return new TreeFactory.Node<Player>(new double[]{loc.getX(), loc.getY(), loc.getZ()}, (Player)p);
                }));
            }
            this.playerFuture = ForkJoinPool.commonPool().submit((Callable)new TreeFactory(map));
        }
    }

    private void updateWorld(World world) {
        Collection players = Collections2.filter((Collection)world.getPlayers(), p -> !p.hasMetadata("NPC"));
        if (players.isEmpty()) {
            this.worlds.remove(world.getUID());
            return;
        }
        PhTreeF tree = this.worlds.computeIfAbsent(world.getUID(), uid -> PhTreeF.create((int)3));
        tree.clear();
        Location loc = new Location(null, 0.0, 0.0, 0.0);
        for (Player player : players) {
            player.getLocation(loc);
            tree.put(new double[]{loc.getX(), loc.getY(), loc.getZ()}, (Object)player);
        }
    }

    public static class PerPlayerMetadata<T> {
        private final BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin;
        private final Map<UUID, Map<String, T>> sent = Maps.newHashMap();

        public PerPlayerMetadata(BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin) {
            this.onJoin = onJoin;
        }

        public T getMarker(UUID key, String value) {
            return (T)this.sent.getOrDefault(key, Collections.emptyMap()).get(value);
        }

        public boolean has(UUID key, String value) {
            return this.sent.getOrDefault(key, Collections.emptyMap()).containsKey(value);
        }

        public boolean remove(UUID key, String value) {
            return this.sent.getOrDefault(key, Collections.emptyMap()).remove(value) != null;
        }

        public void removeAllValues(String value) {
            for (Map<String, T> map : this.sent.values()) {
                map.remove(value);
            }
        }

        public void set(UUID key, String value, T marker) {
            if (marker instanceof Location || marker instanceof World) {
                throw new IllegalArgumentException("Invalid marker");
            }
            this.sent.computeIfAbsent(key, k -> Maps.newHashMap()).put(value, marker);
        }
    }

    private static final class TreeFactory<K, V>
    implements Callable<Map<K, PhTreeF<V>>> {
        private final Map<K, Collection<Node<V>>> source;

        public TreeFactory(Map<K, Collection<Node<V>>> source) {
            this.source = source;
        }

        @Override
        public Map<K, PhTreeF<V>> call() throws Exception {
            HashMap result = Maps.newHashMap();
            for (K k : this.source.keySet()) {
                PhTreeF tree = PhTreeF.create((int)3);
                for (Node<V> entry : this.source.get(k)) {
                    tree.put(entry.loc, entry.t);
                }
                result.put(k, tree);
            }
            return result;
        }

        public static class Node<T> {
            public double[] loc;
            public T t;

            public Node(double[] loc, T t) {
                this.loc = loc;
                this.t = t;
            }
        }
    }

    public static abstract class AsyncPhTreeLoader<K, V>
    implements Runnable {
        private Future<Map<K, PhTreeF<V>>> future;
        protected Map<K, PhTreeF<V>> mapping = Maps.newHashMap();

        protected abstract Map<K, Collection<TreeFactory.Node<V>>> generateLoaderMap();

        public Iterable<V> getNearby(K lookup, double dist, double[] center) {
            PhTreeF tree = this.mapping.get(lookup);
            if (tree == null) {
                return Collections.emptyList();
            }
            return () -> tree.rangeQuery(dist, center);
        }

        public Iterable<V> getNearby(K lookup, double[] min, double[] max) {
            PhTreeF tree = this.mapping.get(lookup);
            if (tree == null) {
                return Collections.emptyList();
            }
            return () -> tree.query(min, max);
        }

        @Override
        public void run() {
            if (this.future != null && this.future.isDone()) {
                try {
                    this.mapping = this.future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                this.future = null;
            }
            if (this.future == null) {
                this.future = ForkJoinPool.commonPool().submit(new TreeFactory<K, V>(this.generateLoaderMap()));
            }
        }
    }
}

