/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@TraitName(value="equipment")
public class Equipment
extends Trait {
    private final ItemStack[] cosmetic = new ItemStack[7];
    private final ItemStack[] equipment = new ItemStack[7];
    private static boolean SUPPORT_BODY = false;
    private static boolean SUPPORT_OFFHAND = true;

    public Equipment() {
        super("equipment");
    }

    private ItemStack clone(ItemStack item) {
        return item == null || item.getType() == Material.AIR ? null : item.clone();
    }

    public ItemStack get(EquipmentSlot slot) {
        return this.get(slot.getIndex());
    }

    public ItemStack get(int slot) {
        if (this.npc.getEntity() instanceof Enderman && slot != 0) {
            throw new IllegalArgumentException("Slot must be 0 for enderman");
        }
        return this.equipment[slot] == null ? null : this.equipment[slot].clone();
    }

    public ItemStack getCosmetic(EquipmentSlot slot) {
        return this.cosmetic[slot.getIndex()] == null ? null : this.cosmetic[slot.getIndex()].clone();
    }

    public ItemStack[] getEquipment() {
        return this.equipment;
    }

    public Map<EquipmentSlot, ItemStack> getEquipmentBySlot() {
        EnumMap map = Maps.newEnumMap(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            map.put(slot, this.equipment[slot.getIndex()] == null ? null : this.equipment[slot.getIndex()].clone());
        }
        return map;
    }

    private EntityEquipment getEquipmentFromEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEquipment();
        }
        throw new IllegalStateException("Unsupported entity equipment");
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            String name = slot.name().toLowerCase(Locale.ROOT);
            if (key.keyExists(name)) {
                this.equipment[slot.getIndex()] = ItemStorage.loadItemStack(key.getRelative(name));
            }
            if (!key.keyExists("cosmetic_" + name)) continue;
            this.cosmetic[slot.getIndex()] = ItemStorage.loadItemStack(key.getRelative("cosmetic_" + name));
        }
    }

    @Override
    public void onAttach() {
        this.npc.scheduleUpdate(NPC.NPCUpdate.PACKET);
        this.run();
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getEntity();
            if (this.equipment[0] != null) {
                if (SpigotUtil.isUsing1_13API()) {
                    enderman.setCarriedBlock(this.equipment[0].getType().createBlockData());
                } else {
                    enderman.setCarriedMaterial(this.equipment[0].getData());
                }
            }
        } else {
            EntityEquipment equip = this.getEquipmentFromEntity(this.npc.getEntity());
            if (this.equipment[0] != null) {
                equip.setItemInHand(this.equipment[0]);
            }
            equip.setHelmet(this.equipment[1]);
            equip.setChestplate(this.equipment[2]);
            equip.setLeggings(this.equipment[3]);
            equip.setBoots(this.equipment[4]);
            if (SUPPORT_OFFHAND) {
                equip.setItemInOffHand(this.equipment[5]);
            }
            if (SUPPORT_BODY && (this.npc.getEntity().getType() == EntityType.WOLF || this.npc.getEntity() instanceof AbstractHorse)) {
                equip.setItem(org.bukkit.inventory.EquipmentSlot.BODY, this.equipment[6]);
            }
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).updateInventory();
        }
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof LivingEntity) || !this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getEntity();
            if (this.equipment[0] != null) {
                this.equipment[0] = SpigotUtil.isUsing1_13API() ? new ItemStack(enderman.getCarriedBlock().getMaterial(), 1) : enderman.getCarriedMaterial().toItemStack(1);
            }
        } else {
            EntityEquipment equip = this.getEquipmentFromEntity(this.npc.getEntity());
            this.equipment[0] = this.clone(equip.getItemInHand());
            this.equipment[1] = this.clone(equip.getHelmet());
            this.equipment[2] = this.clone(equip.getChestplate());
            this.equipment[3] = this.clone(equip.getLeggings());
            this.equipment[4] = this.clone(equip.getBoots());
            if (SUPPORT_OFFHAND) {
                this.equipment[5] = this.clone(equip.getItemInOffHand());
            }
            if (SUPPORT_BODY && (this.npc.getEntity().getType() == EntityType.WOLF || this.npc.getEntity() instanceof AbstractHorse)) {
                this.equipment[6] = this.clone(equip.getItem(org.bukkit.inventory.EquipmentSlot.BODY));
            }
        }
    }

    @Override
    public void save(DataKey key) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.saveOrRemove(key.getRelative(slot.name().toLowerCase(Locale.ROOT)), this.equipment[slot.getIndex()]);
            this.saveOrRemove(key.getRelative("cosmetic_" + slot.name().toLowerCase(Locale.ROOT)), this.cosmetic[slot.getIndex()]);
        }
    }

    private void saveOrRemove(DataKey key, ItemStack item) {
        if (item != null) {
            ItemStorage.saveItem(key, item);
        } else if (key.keyExists("")) {
            key.removeKey("");
        }
    }

    public void set(EquipmentSlot slot, ItemStack item) {
        this.set(slot.getIndex(), item);
    }

    public void set(int slot, ItemStack item) {
        if (item != null) {
            item = item.getType() == Material.AIR ? null : item.clone();
        }
        this.equipment[slot] = item;
        if (slot == 0) {
            this.npc.getOrAddTrait(Inventory.class).setItemInHand(item);
        }
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            if (slot != 0) {
                throw new UnsupportedOperationException("Slot can only be 0 for enderman");
            }
            if (SpigotUtil.isUsing1_13API()) {
                ((Enderman)this.npc.getEntity()).setCarriedBlock(item.getType().createBlockData());
            } else {
                ((Enderman)this.npc.getEntity()).setCarriedMaterial(item.getData());
            }
        } else {
            EntityEquipment equip = this.getEquipmentFromEntity(this.npc.getEntity());
            switch (slot) {
                case 0: {
                    equip.setItemInHand(item);
                    break;
                }
                case 1: {
                    equip.setHelmet(item);
                    break;
                }
                case 2: {
                    equip.setChestplate(item);
                    break;
                }
                case 3: {
                    equip.setLeggings(item);
                    break;
                }
                case 4: {
                    equip.setBoots(item);
                    break;
                }
                case 5: {
                    if (!SUPPORT_OFFHAND) break;
                    equip.setItemInOffHand(item);
                    break;
                }
                case 6: {
                    if (!SUPPORT_BODY || this.npc.getEntity().getType() != EntityType.WOLF && !(this.npc.getEntity() instanceof AbstractHorse)) break;
                    equip.setItem(org.bukkit.inventory.EquipmentSlot.BODY, item);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Slot must be between 0 and 6");
                }
            }
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).updateInventory();
        }
    }

    public void setCosmetic(EquipmentSlot slot, ItemStack stack) {
        this.cosmetic[slot.getIndex()] = stack.clone();
    }

    static {
        try {
            EntityEquipment.class.getMethod("setItemInOffHand", ItemStack.class);
        }
        catch (Exception e) {
            SUPPORT_OFFHAND = false;
        }
        for (org.bukkit.inventory.EquipmentSlot value : org.bukkit.inventory.EquipmentSlot.values()) {
            if (!value.name().equals("BODY")) continue;
            SUPPORT_BODY = true;
            break;
        }
    }

    public static enum EquipmentSlot {
        BODY(6),
        BOOTS(4),
        CHESTPLATE(2),
        HAND(0),
        HELMET(1),
        LEGGINGS(3),
        OFF_HAND(5);

        private final int index;

        private EquipmentSlot(int index) {
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }
    }
}

