/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.expr;

import net.citizensnpcs.api.expr.ExpressionScope;

public interface CompiledExpression {
    public Object evaluate(ExpressionScope var1);

    default public boolean evaluateAsBoolean(ExpressionScope scope) {
        Object result = this.evaluate(scope);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue() != 0.0;
        }
        if (result instanceof String) {
            return !((String)result).isEmpty();
        }
        return true;
    }

    default public double evaluateAsNumber(ExpressionScope scope) {
        Object result = this.evaluate(scope);
        if (result == null) {
            return 0.0;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        if (result instanceof Boolean) {
            return (Boolean)result != false ? 1.0 : 0.0;
        }
        if (result instanceof String) {
            try {
                return Double.parseDouble((String)result);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    default public String evaluateAsString(ExpressionScope scope) {
        Object result = this.evaluate(scope);
        return result == null ? "" : result.toString();
    }
}

