/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.DatabaseType;
import net.citizensnpcs.api.util.QueryRunner;
import net.citizensnpcs.api.util.ResultSetHandler;
import net.citizensnpcs.api.util.Storage;

public class DatabaseStorage
implements Storage {
    private Connection conn;
    private final QueryRunner queryRunner = new QueryRunner();
    private final Map<String, Table> tables = Maps.newHashMap();
    private final Map<String, Traversed> traverseCache = Maps.newHashMap();
    private final DatabaseType type;
    private final String url;
    private final String username;
    private final String password;
    private static final Pattern INTEGER = Pattern.compile("([\\+-]?\\d+)([eE][\\+-]?\\d+)?");
    private static final Traversed INVALID_TRAVERSAL = new Traversed(null, null, null);

    public DatabaseStorage(String driver, String url, String username, String password) throws SQLException {
        this.url = "jdbc:" + url;
        this.username = username;
        this.password = password;
        this.type = DatabaseType.match(driver);
        this.type.load();
    }

    private void createForeignKey(Table from, Table to) {
        String fk = "fk_" + to.name;
        Connection conn = this.getConnection();
        try {
            for (String sql : this.type.prepareForeignKeySQL(from, to, fk)) {
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.execute();
                stmt.close();
            }
            from.addForeignKey(fk);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table createTable(String name, int type, boolean autoIncrement) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Table t = this.tables.get(name);
        if (t != null) {
            return t;
        }
        String pk = name + "_id";
        String directType = "";
        String primaryType = " NOT NULL PRIMARY KEY";
        switch (type) {
            case 4: {
                directType = "INTEGER";
                if (!autoIncrement) break;
                primaryType = primaryType + " AUTO_INCREMENT";
                break;
            }
            case 12: {
                directType = "VARCHAR(255)";
                break;
            }
            default: {
                throw new IllegalArgumentException("type not supported");
            }
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        Table created = null;
        try {
            stmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + name + "`(`" + pk + "` " + directType + primaryType + ")");
            stmt.execute();
            created = new Table().setName(name).setPrimaryKey(pk).setPrimaryKeyType(directType);
            this.tables.put(name, created);
            DatabaseStorage.closeQuietly(stmt);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DatabaseStorage.closeQuietly(stmt);
        }
        return created;
    }

    private String ensureRelation(String pk, Table from, final Table to) {
        Connection conn = this.getConnection();
        try {
            String existing = this.queryRunner.query(conn, "SELECT `fk_" + to.name + "` FROM " + from.name + " WHERE " + from.primaryKey + " = ?", new ResultSetHandler<String>(){

                @Override
                public String handle(ResultSet rs) throws SQLException {
                    return rs.next() ? rs.getString("fk_" + to.name) : null;
                }
            }, pk);
            if (existing == null) {
                String generated = to.generateRow();
                this.queryRunner.update(conn, "UPDATE `" + from.name + "` SET `fk_" + to.name + "`=?", (Object)generated);
                return generated;
            }
            return existing;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Connection getConnection() {
        block8: {
            if (this.conn != null) {
                try {
                    if (this.conn.isClosed()) {
                        this.conn = null;
                    } else {
                        this.conn.prepareStatement("SELECT 1;").execute();
                    }
                }
                catch (SQLException ex) {
                    if (!"08S01".equals(ex.getSQLState())) break block8;
                    DatabaseStorage.closeQuietly(this.conn);
                }
            }
        }
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = this.username.isEmpty() && this.password.isEmpty() ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
                return this.conn;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
        return this.conn;
    }

    @Override
    public DataKey getKey(String root) {
        return new DatabaseKey(root);
    }

    @Override
    public boolean load() {
        this.tables.clear();
        this.traverseCache.clear();
        Connection conn = this.getConnection();
        try {
            ResultSet rs = conn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME"), new Table());
            }
            rs.close();
            for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
                Table table = entry.getValue();
                table.name = entry.getKey();
                rs = conn.getMetaData().getColumns(null, null, table.name, null);
                while (rs.next()) {
                    table.addColumn(rs.getString("COLUMN_NAME"));
                }
                rs.close();
                rs = conn.getMetaData().getPrimaryKeys(null, null, table.name);
                while (rs.next()) {
                    table.primaryKey = rs.getString("COLUMN_NAME");
                    table.setPrimaryKeyType(rs.getMetaData().getColumnTypeName(4));
                }
                rs.close();
                rs = conn.getMetaData().getImportedKeys(null, null, table.name);
                while (rs.next()) {
                    table.addForeignKey(rs.getString("PKCOLUMN_NAME"));
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void save() {
        DatabaseStorage.commitAndCloseQuietly(this.conn);
    }

    public String toString() {
        return "DatabaseStorage {url=" + this.url + ", username=" + this.username + ", password=" + this.password + "}";
    }

    private static void closeQuietly(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commitAndCloseQuietly(Connection conn) {
        try {
            try {
                conn.commit();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean loadDriver(ClassLoader classLoader, String driverClassName) {
        try {
            classLoader.loadClass(driverClassName).newInstance();
            return true;
        }
        catch (IllegalAccessException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class Traversed {
        private final String column;
        private final Table found;
        private final String key;

        Traversed(Table found, String pk, String column) {
            this.found = found;
            this.key = pk;
            this.column = column;
        }

        public String toString() {
            return "Traversed [column=" + this.column + ", found=" + this.found + ", key=" + this.key + "]";
        }
    }

    public class Table {
        private final List<String> columns = Lists.newArrayList();
        String name;
        String primaryKey;
        String primaryKeyType;

        public void addColumn(String column) {
            if (this.columns.contains(column)) {
                throw new IllegalArgumentException(column + " already exists in " + this.name);
            }
            if (column.equalsIgnoreCase(this.primaryKey) || column.equalsIgnoreCase(this.name)) {
                return;
            }
            this.columns.add(column);
        }

        public void addForeignKey(String fk) {
            if (this.columns.contains(fk)) {
                throw new IllegalArgumentException(fk + " already exists in " + this.name);
            }
            this.columns.add(fk);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String generateRow() {
            String string;
            ResultSet rs;
            PreparedStatement stmt;
            block9: {
                String string2;
                block8: {
                    StringBuilder nullBuilder = new StringBuilder();
                    int size = this.columns.size() + 1;
                    for (int i = 0; i < size; ++i) {
                        nullBuilder.append("NULL,");
                    }
                    String nulls = nullBuilder.substring(0, nullBuilder.length() - 1).toString();
                    Connection conn = DatabaseStorage.this.getConnection();
                    stmt = null;
                    rs = null;
                    try {
                        stmt = conn.prepareStatement("INSERT INTO `" + this.name + "` VALUES (" + nulls + ")", 1);
                        stmt.execute();
                        rs = stmt.getGeneratedKeys();
                        if (!rs.next()) {
                            string2 = null;
                            DatabaseStorage.closeQuietly(stmt);
                            break block8;
                        }
                        string = rs.getString(1);
                        DatabaseStorage.closeQuietly(stmt);
                        break block9;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
                DatabaseStorage.closeQuietly(rs);
                return string2;
            }
            DatabaseStorage.closeQuietly(rs);
            return string;
            finally {
                DatabaseStorage.closeQuietly(stmt);
                DatabaseStorage.closeQuietly(rs);
            }
        }

        public boolean hasColumn(String column) {
            return this.columns.contains(column);
        }

        public void insert(String primary) {
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                DatabaseStorage.this.queryRunner.update(conn, "INSERT INTO `" + this.name + "` (`" + this.primaryKey + "`) VALUES (?)", (Object)primary);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        public Table setName(String tableName) {
            this.name = tableName;
            return this;
        }

        public Table setPrimaryKey(String pk) {
            this.primaryKey = pk;
            return this;
        }

        public Table setPrimaryKeyType(String type) {
            this.primaryKeyType = type;
            return this;
        }

        public String toString() {
            return "Table {name=" + this.name + ", primaryKey=" + this.primaryKey + ", columns=" + this.columns + "}";
        }
    }

    public class DatabaseKey
    extends DataKey {
        private final String current;

        private DatabaseKey() {
            this("");
        }

        private DatabaseKey(String root) {
            this.current = root;
        }

        private String createRelativeKey(String from) {
            if ((from = from.replace("-", "")).isEmpty()) {
                return this.current;
            }
            if (from.charAt(0) == '.') {
                return this.current.isEmpty() ? from.substring(1, from.length()) : this.current + from;
            }
            return this.current.isEmpty() ? from : this.current + "." + from;
        }

        @Override
        public boolean getBoolean(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return false;
            }
            Boolean value = this.getValue(t, new ResultSetHandler<Boolean>(){

                @Override
                public Boolean handle(ResultSet rs) throws SQLException {
                    return rs.next() ? Boolean.valueOf(rs.getBoolean(t.column)) : null;
                }
            });
            return value == null ? false : value;
        }

        @Override
        public double getDouble(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0.0;
            }
            Double value = this.getValue(t, new ResultSetHandler<Double>(){

                @Override
                public Double handle(ResultSet rs) throws SQLException {
                    return rs.next() ? Double.valueOf(rs.getDouble(t.column)) : null;
                }
            });
            return value == null ? 0.0 : value;
        }

        @Override
        public int getInt(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0;
            }
            Integer value = this.getValue(t, new ResultSetHandler<Integer>(){

                @Override
                public Integer handle(ResultSet rs) throws SQLException {
                    return rs.next() ? Integer.valueOf(rs.getInt(t.column)) : null;
                }
            });
            return value == null ? 0 : value;
        }

        @Override
        public long getLong(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0L;
            }
            Long value = this.getValue(t, new ResultSetHandler<Long>(){

                @Override
                public Long handle(ResultSet rs) throws SQLException {
                    return rs.next() ? Long.valueOf(rs.getLong(t.column)) : null;
                }
            });
            return value == null ? 0L : value;
        }

        @Override
        public Object getRaw(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return null;
            }
            Object value = this.getValue(t, new ResultSetHandler<Object>(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    return rs.next() ? rs.getObject(t.column) : null;
                }
            });
            return value;
        }

        @Override
        public DataKey getRelative(String relative) {
            if (relative == null || relative.isEmpty()) {
                return this;
            }
            return new DatabaseKey(this.createRelativeKey(relative));
        }

        protected Traversed getRoot() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterable<DataKey> getSingleKeys(List<DataKey> keys) {
            block8: {
                if (!DatabaseStorage.this.tables.containsKey(this.current)) {
                    return keys;
                }
                Table table = (Table)DatabaseStorage.this.tables.get(this.current);
                if (table.primaryKey == null) {
                    return keys;
                }
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    Connection conn = DatabaseStorage.this.getConnection();
                    stmt = conn.prepareStatement("SELECT `" + table.primaryKey + "` FROM `" + this.current + "`");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        final Traversed found = new Traversed(table, rs.getString(table.primaryKey), table.primaryKey);
                        keys.add(new DatabaseKey(){

                            @Override
                            public Traversed getRoot() {
                                return found;
                            }
                        });
                    }
                    DatabaseStorage.closeQuietly(stmt);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    break block8;
                }
                finally {
                    DatabaseStorage.closeQuietly(stmt);
                    DatabaseStorage.closeQuietly(rs);
                }
                DatabaseStorage.closeQuietly(rs);
            }
            return keys;
        }

        @Override
        public String getString(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return "";
            }
            String value = this.getValue(t, new ResultSetHandler<String>(){

                @Override
                public String handle(ResultSet rs) throws SQLException {
                    return rs.next() ? rs.getString(t.column) : null;
                }
            });
            return value == null ? "" : value;
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            ArrayList keys = Lists.newArrayList();
            if (this.current.split("\\.").length == 1) {
                return this.getSingleKeys(keys);
            }
            return keys;
        }

        private <T> T getValue(Traversed t, ResultSetHandler<T> resultSetHandler) {
            if (!t.found.hasColumn(t.column)) {
                return null;
            }
            try {
                return DatabaseStorage.this.queryRunner.query(DatabaseStorage.this.getConnection(), "SELECT `" + t.column + "` FROM " + ((Traversed)t).found.name + " WHERE `" + ((Traversed)t).found.primaryKey + "`=?", resultSetHandler, t.key);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean keyExists(String key) {
            return this.traverse(this.createRelativeKey(key), false) != INVALID_TRAVERSAL;
        }

        @Override
        public String name() {
            Traversed t = this.traverse(this.current, true);
            System.err.println(t);
            return t.key != null ? t.key : ((Traversed)t).found.name;
        }

        @Override
        public void removeKey(String key) {
            Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return;
            }
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                if (t.found.hasColumn(t.column)) {
                    DatabaseStorage.this.queryRunner.update(conn, "UPDATE `" + ((Traversed)t).found.name + "` SET `" + t.column + "`=? WHERE `" + ((Traversed)t).found.primaryKey + "`=?", null, t.key);
                } else {
                    DatabaseStorage.this.queryRunner.update(conn, "DELETE FROM `" + ((Traversed)t).found.name + "` WHERE `" + ((Traversed)t).found.primaryKey + "=?", (Object)t.key);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.setValue("SMALLINT", key, value);
        }

        @Override
        public void setDouble(String key, double value) {
            this.setValue("DOUBLE", key, value);
        }

        @Override
        public void setInt(String key, int value) {
            this.setValue("STRING", key, value);
        }

        @Override
        public void setLong(String key, long value) {
            this.setValue("BIGINT", key, value);
        }

        @Override
        public void setRaw(String key, Object value) {
            this.setValue("JAVA_OBJECT", key, value);
        }

        @Override
        public void setString(String key, String value) {
            this.setValue("VARCHAR", key, value);
        }

        private void setValue(String type, String key, Object value) {
            Traversed t = this.traverse(this.createRelativeKey(key), true);
            if (t == INVALID_TRAVERSAL) {
                System.err.println("Could not set " + value + " at " + key);
                return;
            }
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                if (!t.found.hasColumn(t.column)) {
                    PreparedStatement stmt = conn.prepareStatement("ALTER TABLE `" + ((Traversed)t).found.name + "` ADD `" + t.column + "` " + type);
                    stmt.execute();
                    DatabaseStorage.closeQuietly(stmt);
                    t.found.addColumn(t.column);
                }
                DatabaseStorage.this.queryRunner.update(conn, "UPDATE " + ((Traversed)t).found.name + " SET " + t.column + "=? WHERE " + ((Traversed)t).found.primaryKey + "=?", value, t.key);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.out.println("UPDATE " + ((Traversed)t).found.name + " SET " + t.column + "=? WHERE " + ((Traversed)t).found.primaryKey + "=?" + " " + value + " " + t.key);
            }
        }

        private Traversed traverse(String path, boolean createRelations) {
            String pk;
            Table table;
            Traversed prev = (Traversed)DatabaseStorage.this.traverseCache.get(path);
            if (prev != null) {
                return prev;
            }
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)path), String.class);
            Traversed root = this.getRoot();
            int i = 0;
            if (root == null) {
                if (parts.length < 2) {
                    return INVALID_TRAVERSAL;
                }
                table = (Table)DatabaseStorage.this.tables.get(parts[0]);
                pk = parts[1];
                if (table == null) {
                    if (!createRelations) {
                        return INVALID_TRAVERSAL;
                    }
                    int type = INTEGER.matcher(pk).matches() ? 4 : 12;
                    table = DatabaseStorage.this.createTable(parts[0], type, false);
                    if (table == null) {
                        return INVALID_TRAVERSAL;
                    }
                    table.insert(pk);
                }
                i = 2;
            } else {
                table = root.found;
                pk = root.key;
            }
            while (i < parts.length - 1) {
                boolean needRelationToNext;
                boolean missingTable;
                String part = parts[i];
                Table next = (Table)DatabaseStorage.this.tables.get(part);
                boolean bl = missingTable = next == null;
                if (missingTable && (next = DatabaseStorage.this.createTable(part, 4, true)) == null) {
                    return INVALID_TRAVERSAL;
                }
                boolean bl2 = needRelationToNext = !table.hasColumn("fk_" + next.name);
                if (needRelationToNext) {
                    if (!createRelations) {
                        return INVALID_TRAVERSAL;
                    }
                    DatabaseStorage.this.createForeignKey(table, next);
                }
                if ((pk = DatabaseStorage.this.ensureRelation(pk, table, next)) == null) {
                    return INVALID_TRAVERSAL;
                }
                table = next;
                ++i;
            }
            String setColumn = parts.length == 0 ? null : parts[parts.length - 1];
            Traversed t = new Traversed(table, pk, setColumn);
            DatabaseStorage.this.traverseCache.put(path, t);
            return t;
        }
    }
}

