/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;

public abstract class Composite
extends BehaviorGoalAdapter {
    private final List<Behavior> behaviors;

    public Composite(Behavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    public Composite(Collection<Behavior> behaviors) {
        this.behaviors = Lists.newArrayList(behaviors);
    }

    public void addBehavior(Behavior behavior) {
        this.behaviors.add(behavior);
    }

    protected List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void removeBehavior(Behavior behavior) {
        this.behaviors.remove(behavior);
    }

    @Override
    public boolean shouldExecute() {
        return this.behaviors.size() > 0;
    }
}

