/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.SimpleGoalEntry;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public class SimpleGoalController
implements GoalController {
    private final List<Goal> executingGoals = Lists.newArrayList();
    private int executingPriority = -1;
    private Goal executingRootGoal;
    private volatile boolean paused;
    private final List<GoalController.GoalEntry> possibleGoals = Lists.newArrayList();
    private final GoalSelector selector = new SimpleGoalSelector();

    @Override
    public void addGoal(Goal goal, int priority) {
        Preconditions.checkNotNull((Object)goal, (Object)"goal cannot be null");
        Preconditions.checkState((priority > 0 && priority < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"priority must be greater than 0");
        SimpleGoalEntry entry = new SimpleGoalEntry(goal, priority);
        if (this.possibleGoals.contains(entry)) {
            return;
        }
        this.possibleGoals.add(entry);
        Collections.sort(this.possibleGoals);
    }

    private void addGoalToExecution(Goal goal) {
        if (CitizensAPI.hasImplementation()) {
            Bukkit.getPluginManager().registerEvents((Listener)goal, CitizensAPI.getPlugin());
        }
        this.executingGoals.add(goal);
        goal.run(this.selector);
    }

    @Override
    public void clear() {
        this.finishCurrentGoalExecution();
        this.possibleGoals.clear();
    }

    private void finishCurrentGoalExecution() {
        this.resetGoalList();
        this.executingPriority = -1;
        HandlerList.unregisterAll((Listener)this.executingRootGoal);
        this.executingRootGoal = null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public Iterator<GoalController.GoalEntry> iterator() {
        final Iterator<GoalController.GoalEntry> itr = this.possibleGoals.iterator();
        return new Iterator<GoalController.GoalEntry>(){
            GoalController.GoalEntry cur;

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public GoalController.GoalEntry next() {
                this.cur = (GoalController.GoalEntry)itr.next();
                return this.cur;
            }

            @Override
            public void remove() {
                itr.remove();
                if (this.cur.getGoal() == SimpleGoalController.this.executingRootGoal) {
                    SimpleGoalController.this.finishCurrentGoalExecution();
                }
            }
        };
    }

    @Override
    public void removeGoal(Goal goal) {
        Preconditions.checkNotNull((Object)goal, (Object)"goal cannot be null");
        for (int j = 0; j < this.possibleGoals.size(); ++j) {
            Goal test = this.possibleGoals.get(j).getGoal();
            if (!test.equals(goal)) continue;
            this.possibleGoals.remove(j--);
            if (test != this.executingRootGoal) continue;
            this.finishCurrentGoalExecution();
        }
    }

    private void resetGoalList() {
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            Goal goal = this.executingGoals.remove(i--);
            goal.reset();
            HandlerList.unregisterAll((Listener)goal);
        }
    }

    @Override
    public void run() {
        if (this.possibleGoals.isEmpty() || this.paused) {
            return;
        }
        this.trySelectGoal();
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            Goal goal = this.executingGoals.get(i);
            goal.run(this.selector);
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private void setupExecution(GoalController.GoalEntry entry) {
        this.finishCurrentGoalExecution();
        this.executingPriority = entry.getPriority();
        this.executingRootGoal = entry.getGoal();
        this.addGoalToExecution(entry.getGoal());
    }

    private void trySelectGoal() {
        int searchPriority = Math.max(this.executingPriority, 1);
        for (int i = this.possibleGoals.size() - 1; i >= 0; --i) {
            GoalController.GoalEntry entry = this.possibleGoals.get(i);
            if (searchPriority > entry.getPriority()) {
                return;
            }
            if (entry.getGoal() == this.executingRootGoal || !entry.getGoal().shouldExecute(this.selector)) continue;
            if (i == 0) {
                this.setupExecution(entry);
                return;
            }
            for (int j = i - 1; j >= 0; --j) {
                int ran;
                boolean unequalPriorities;
                GoalController.GoalEntry next = this.possibleGoals.get(j);
                boolean bl = unequalPriorities = next.getPriority() != entry.getPriority();
                if (!unequalPriorities && j != 0) continue;
                if (unequalPriorities) {
                    ++j;
                }
                if ((ran = (int)Math.floor(Math.random() * (double)(i - j + 1) + (double)j)) >= this.possibleGoals.size() || ran < 0) {
                    this.setupExecution(entry);
                    break;
                }
                GoalController.GoalEntry selected = this.possibleGoals.get(ran);
                if (selected.getPriority() != entry.getPriority()) {
                    this.setupExecution(entry);
                    break;
                }
                this.setupExecution(selected);
                break;
            }
            return;
        }
    }

    public class SimpleGoalSelector
    implements GoalSelector {
        @Override
        public void finish() {
            SimpleGoalController.this.finishCurrentGoalExecution();
        }

        @Override
        public void finishAndRemove() {
            Goal toRemove = SimpleGoalController.this.executingRootGoal;
            this.finish();
            if (toRemove != null) {
                SimpleGoalController.this.removeGoal(toRemove);
            }
        }

        @Override
        public void select(Goal goal) {
            SimpleGoalController.this.resetGoalList();
            SimpleGoalController.this.addGoalToExecution(goal);
        }

        @Override
        public void selectAdditional(Goal ... goals) {
            for (Goal goal : goals) {
                SimpleGoalController.this.addGoalToExecution(goal);
            }
        }
    }
}

