/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import net.citizensnpcs.api.jnbt.ByteTag;
import net.citizensnpcs.api.jnbt.CompoundTag;
import net.citizensnpcs.api.jnbt.DoubleTag;
import net.citizensnpcs.api.jnbt.IntTag;
import net.citizensnpcs.api.jnbt.LongTag;
import net.citizensnpcs.api.jnbt.NBTInputStream;
import net.citizensnpcs.api.jnbt.NBTOutputStream;
import net.citizensnpcs.api.jnbt.StringTag;
import net.citizensnpcs.api.jnbt.Tag;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.bukkit.Bukkit;

public class NBTStorage
implements Storage {
    private final File file;
    private final String name;
    private final Map<String, Tag> root = Maps.newHashMap();

    public NBTStorage(String file) {
        this(file, "root");
    }

    public NBTStorage(String file, String name) {
        this.file = new File(file);
        if (!this.file.exists()) {
            this.create();
        }
        this.name = name;
    }

    private void create() {
        try {
            Bukkit.getLogger().log(Level.INFO, "Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not create file: " + this.file.getName());
        }
    }

    @Override
    public DataKey getKey(String root) {
        return new NBTKey(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        NBTInputStream stream = null;
        try {
            stream = new NBTInputStream(new GZIPInputStream(new FileInputStream(this.file)));
            Tag tag = stream.readTag();
            if (tag == null || !(tag instanceof CompoundTag)) {
                boolean bl = false;
                Closeables.closeQuietly((Closeable)stream);
                return bl;
            }
            this.root.clear();
            this.root.putAll((Map<String, Tag>)((CompoundTag)tag).getValue());
            Closeables.closeQuietly((Closeable)stream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            Closeables.closeQuietly(stream);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        NBTOutputStream stream = null;
        try {
            Files.createParentDirs((File)this.file);
            File temporaryFile = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            temporaryFile.deleteOnExit();
            stream = new NBTOutputStream(new FileOutputStream(temporaryFile));
            stream.writeTag(new CompoundTag(this.name, this.root));
            stream.close();
            this.file.delete();
            temporaryFile.renameTo(this.file);
            temporaryFile.delete();
            Closeables.closeQuietly((Closeable)stream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            Closeables.closeQuietly(stream);
        }
    }

    public String toString() {
        return "NBTStorage {file=" + this.file + "}";
    }

    private static class Node {
        final String parent;
        final Map<String, Tag> values;

        public Node(String parent, Tag tag) {
            this.parent = parent;
            this.values = ((CompoundTag)tag).getValue();
        }

        public Node(Tag tag) {
            this("", tag);
        }
    }

    public class NBTKey
    extends DataKey {
        public NBTKey(String root) {
            super(root);
        }

        private String createRelativeKey(String parent, String sub) {
            if (sub.isEmpty()) {
                return parent;
            }
            if (sub.charAt(0) == '.') {
                return parent.isEmpty() ? sub.substring(1, sub.length()) : parent + sub;
            }
            return parent.isEmpty() ? sub : parent + "." + sub;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NBTKey other = (NBTKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        private Map<String, Tag> findLastParent(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)key), String.class);
            Object map = NBTStorage.this.root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!map.containsKey(parts[i]) || !(map.get(parts[i]) instanceof CompoundTag)) {
                    return null;
                }
                map = ((CompoundTag)map.get(parts[i])).getValue();
            }
            return map;
        }

        private Tag findLastTag(String key) {
            return this.findLastTag(key, true);
        }

        private Tag findLastTag(String key, boolean relative) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)(relative ? this.createRelativeKey(key) : key)), String.class);
            Map<String, Tag> map = this.findLastParent(key);
            if (!map.containsKey(parts[parts.length - 1])) {
                return null;
            }
            return map.get(parts[parts.length - 1]);
        }

        @Override
        public boolean getBoolean(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof ByteTag)) {
                return false;
            }
            return ((ByteTag)tag).getValue() != 0;
        }

        @Override
        public double getDouble(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof DoubleTag)) {
                return 0.0;
            }
            return ((DoubleTag)tag).getValue();
        }

        @Override
        public int getInt(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof IntTag)) {
                return 0;
            }
            return ((IntTag)tag).getValue();
        }

        @Override
        public long getLong(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof LongTag)) {
                return 0L;
            }
            return ((LongTag)tag).getValue();
        }

        private String getNameFor(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            return parts[parts.length - 1];
        }

        private NBTStorage getOuterType() {
            return NBTStorage.this;
        }

        @Override
        public Object getRaw(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataKey getRelative(String relative) {
            return new NBTKey(this.createRelativeKey(relative));
        }

        @Override
        public String getString(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof StringTag)) {
                return "";
            }
            return ((StringTag)tag).getValue();
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            Tag tag = this.findLastTag(this.path, false);
            if (!(tag instanceof CompoundTag)) {
                return Collections.emptyList();
            }
            ArrayList subKeys = Lists.newArrayList();
            for (String name : ((CompoundTag)tag).getValue().keySet()) {
                subKeys.add(new NBTKey(this.createRelativeKey(name)));
            }
            return subKeys;
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            Tag tag = this.findLastTag(this.path, false);
            if (!(tag instanceof CompoundTag)) {
                return Collections.emptyMap();
            }
            ArrayDeque<Node> node = new ArrayDeque<Node>((Collection<Node>)ImmutableList.of((Object)new Node(tag)));
            HashMap values = Maps.newHashMap();
            while (!node.isEmpty()) {
                Node root = (Node)node.poll();
                for (Map.Entry<String, Tag> entry : root.values.entrySet()) {
                    String key = this.createRelativeKey(root.parent, entry.getKey());
                    if (entry.getValue() instanceof CompoundTag) {
                        node.add(new Node(key, entry.getValue()));
                        continue;
                    }
                    values.put(key, entry.getValue().getValue());
                }
            }
            return values;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        @Override
        public boolean keyExists(String key) {
            return this.findLastTag(this.createRelativeKey(key)) != null;
        }

        @Override
        public String name() {
            int last = this.path.lastIndexOf(46);
            return this.path.substring(last == 0 ? 0 : last + 1);
        }

        private void putTag(String key, Tag tag) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            Object parent = NBTStorage.this.root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!parent.containsKey(parts[i]) || !(parent.get(parts[i]) instanceof CompoundTag)) {
                    parent.put(parts[i], new CompoundTag(parts[i]));
                }
                parent = ((CompoundTag)parent.get(parts[i])).getValue();
            }
            parent.put(tag.getName(), tag);
        }

        @Override
        public void removeKey(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)key), String.class);
            Map<String, Tag> parent = this.findLastParent(this.createRelativeKey(key));
            parent.remove(parts[parts.length - 1]);
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.putTag(key, new ByteTag(this.getNameFor(key), (byte)(value ? 1 : 0)));
        }

        @Override
        public void setDouble(String key, double value) {
            this.putTag(key, new DoubleTag(this.getNameFor(key), value));
        }

        @Override
        public void setInt(String key, int value) {
            this.putTag(key, new IntTag(this.getNameFor(key), value));
        }

        @Override
        public void setLong(String key, long value) {
            this.putTag(key, new LongTag(this.getNameFor(key), value));
        }

        @Override
        public void setRaw(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setString(String key, String value) {
            this.putTag(key, new StringTag(this.getNameFor(key), value));
        }
    }
}

