/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util.prtree;

import net.citizensnpcs.api.util.prtree.MBR;
import net.citizensnpcs.api.util.prtree.MBRConverter;
import org.bukkit.util.Vector;

public class Region3D<T>
implements MBR {
    private final T data;
    private final Vector min;
    private final Vector max;

    public Region3D(Vector min, Vector max, T data) {
        this.min = min;
        this.max = max;
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    @Override
    public int getDimensions() {
        return 3;
    }

    @Override
    public double getMax(int axis) {
        switch (axis) {
            case 0: {
                return this.max.getBlockX();
            }
            case 1: {
                return this.max.getBlockY();
            }
            case 2: {
                return this.max.getBlockZ();
            }
        }
        return 0.0;
    }

    @Override
    public double getMin(int axis) {
        switch (axis) {
            case 0: {
                return this.min.getBlockX();
            }
            case 1: {
                return this.min.getBlockY();
            }
            case 2: {
                return this.min.getBlockZ();
            }
        }
        return 0.0;
    }

    public <I> boolean intersects(I t, MBRConverter<I> converter) {
        converter.getMin(this.getDimensions(), t);
        return false;
    }

    @Override
    public boolean intersects(MBR other) {
        if (other.getMax(0) < (double)this.min.getBlockX() || other.getMax(1) < (double)this.min.getBlockY() || other.getMax(2) < (double)this.min.getBlockZ()) {
            return false;
        }
        if (other.getMin(0) > (double)this.max.getBlockX() || other.getMin(1) > (double)this.max.getBlockY() || other.getMin(2) > (double)this.max.getBlockZ()) {
            return false;
        }
        return false;
    }

    @Override
    public MBR union(MBR mbr) {
        Vector umin = new Vector(Math.min(this.min.getX(), mbr.getMin(0)), Math.min(this.min.getY(), mbr.getMin(1)), Math.min(this.min.getZ(), mbr.getMin(2)));
        Vector umax = new Vector(Math.max(this.max.getX(), mbr.getMax(0)), Math.max(this.max.getY(), mbr.getMax(1)), Math.max(this.max.getZ(), mbr.getMax(2)));
        return new Region3D<T>(umin, umax, this.data);
    }

    public static class Converter<C>
    implements MBRConverter<Region3D<C>> {
        @Override
        public int getDimensions() {
            return 3;
        }

        @Override
        public double getMax(int axis, Region3D<C> t) {
            return t.getMax(axis);
        }

        @Override
        public double getMin(int axis, Region3D<C> t) {
            return t.getMin(axis);
        }
    }
}

