/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.SimpleGoalController;
import net.citizensnpcs.api.ai.speech.SimpleSpeechController;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRemoveTraitEvent;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Speech;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public abstract class AbstractNPC
implements NPC {
    private final GoalController goalController = new SimpleGoalController();
    private final int id;
    protected final MetadataStore metadata = new SimpleMetadataStore(this);
    private String name;
    private final List<String> removedTraits = Lists.newArrayList();
    protected final List<Runnable> runnables = Lists.newArrayList();
    private final SpeechController speechController = new SimpleSpeechController(this);
    protected final Map<Class<? extends Trait>, Trait> traits = Maps.newHashMap();

    protected AbstractNPC(int id, String name) {
        if (name.length() > 16) {
            Messaging.severe("ID", id, "created with name length greater than 16, truncating", name, "to", name.substring(0, 15));
            name = name.substring(0, 15);
        }
        this.id = id;
        this.name = name;
        this.addTrait(MobType.class);
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            Messaging.severe("Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait.getNPC() == null) {
            trait.linkToNPC(this);
        }
        Trait replaced = this.traits.get(trait.getClass());
        Bukkit.getPluginManager().registerEvents((Listener)trait, CitizensAPI.getPlugin());
        this.traits.put(trait.getClass(), trait);
        if (this.isSpawned()) {
            trait.onSpawn();
        }
        if (trait.isRunImplemented()) {
            if (replaced != null) {
                this.runnables.remove(replaced);
            }
            this.runnables.add(trait);
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCAddTraitEvent(this, trait));
    }

    @Override
    public NPC clone() {
        NPC copy = CitizensAPI.getNPCRegistry().createNPC(this.getTrait(MobType.class).getType(), this.getFullName());
        MemoryDataKey key = new MemoryDataKey();
        this.save(key);
        copy.load(key);
        for (Trait trait : copy.getTraits()) {
            trait.onCopy();
        }
        return copy;
    }

    @Override
    public MetadataStore data() {
        return this.metadata;
    }

    @Override
    public boolean despawn() {
        return this.despawn(DespawnReason.PLUGIN);
    }

    @Override
    public void destroy() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove();
        }
        this.traits.clear();
        CitizensAPI.getNPCRegistry().deregister(this);
    }

    @Override
    public GoalController getDefaultGoalController() {
        return this.goalController;
    }

    @Override
    public SpeechController getDefaultSpeechController() {
        if (!this.hasTrait(Speech.class)) {
            this.addTrait(Speech.class);
        }
        return this.speechController;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        String parsed = this.name;
        for (ChatColor color : ChatColor.values()) {
            if (!parsed.contains("<" + color.getChar() + ">")) continue;
            parsed = parsed.replace("<" + color.getChar() + ">", "");
        }
        return parsed;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        Trait trait = this.traits.get(clazz);
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)(trait != null ? (Trait)clazz.cast(trait) : null);
    }

    protected Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public Iterable<Trait> getTraits() {
        return this.traits.values();
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public boolean isProtected() {
        return this.data().get("protected", true);
    }

    @Override
    public void load(final DataKey root) {
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        HashSet keys = Sets.newHashSet(root.getRelative("traits").getSubKeys());
        Iterables.addAll((Collection)keys, (Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)traitNames), (Function)new Function<String, DataKey>(){

            public DataKey apply(@Nullable String input) {
                return root.getRelative("traits." + input);
            }
        }));
        for (DataKey traitKey : keys) {
            Trait trait;
            if (traitKey.keyExists("enabled") && !traitKey.getBoolean("enabled") && traitKey.getRaw("enabled") instanceof Boolean) continue;
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
            if (this.hasTrait(clazz)) {
                trait = this.getTrait(clazz);
                this.loadTrait(trait, traitKey);
                continue;
            }
            trait = CitizensAPI.getTraitFactory().getTrait(clazz);
            if (trait == null) {
                Messaging.severeTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
                continue;
            }
            this.loadTrait(trait, traitKey);
            this.addTrait(trait);
        }
    }

    private void loadTrait(Trait trait, DataKey traitKey) {
        try {
            trait.load(traitKey);
            PersistenceLoader.load(trait, traitKey);
        }
        catch (Throwable ex) {
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> traitClass) {
        Trait trait = this.traits.remove(traitClass);
        if (trait != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCRemoveTraitEvent(this, trait));
            this.removedTraits.add(trait.getName());
            if (trait.isRunImplemented()) {
                this.runnables.remove(trait);
            }
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove();
        }
    }

    @Override
    public void save(DataKey root) {
        this.metadata.saveTo(root.getRelative("metadata"));
        root.setString("name", this.getFullName());
        StringBuilder traitNames = new StringBuilder();
        for (Trait trait : this.traits.values()) {
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            trait.save(traitKey);
            PersistenceLoader.save(trait, traitKey);
            this.removedTraits.remove(trait.getName());
            traitNames.append(trait.getName() + ",");
        }
        if (traitNames.length() > 0) {
            root.setString("traitnames", traitNames.substring(0, traitNames.length() - 1));
        } else {
            root.setString("traitnames", "");
        }
        for (String name : this.removedTraits) {
            root.removeKey("traits." + name);
        }
        this.removedTraits.clear();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (!this.isSpawned()) {
            return;
        }
        LivingEntity bukkitEntity = this.getBukkitEntity();
        bukkitEntity.setCustomName(this.getFullName());
        if (bukkitEntity.getType() == EntityType.PLAYER) {
            Location old = bukkitEntity.getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
            this.spawn(old);
        }
    }

    @Override
    public void setProtected(boolean isProtected) {
        this.data().setPersistent("protected", isProtected);
    }

    public void update() {
        for (int i = 0; i < this.runnables.size(); ++i) {
            this.runnables.get(i).run();
        }
        if (this.isSpawned()) {
            this.goalController.run();
        }
    }
}

