/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandAnnotationProcessor;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.command.RequirementsProcessor;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.command.exception.UnhandledCommandException;
import net.citizensnpcs.api.command.exception.WrappedCommandException;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandManager {
    private final Map<Class<? extends Annotation>, CommandAnnotationProcessor> annotationProcessors = Maps.newHashMap();
    private final Map<String, Method> commands = new HashMap<String, Method>();
    private Injector injector;
    private final Map<Method, Object> instances = new HashMap<Method, Object>();
    private final ListMultimap<Method, Annotation> registeredAnnotations = ArrayListMultimap.create();
    private final Set<Method> serverCommands = new HashSet<Method>();
    private static final String COMMAND_FORMAT = "<7>/<c>%s%s <7>- <e>%s";
    private static final Logger logger = Logger.getLogger(CommandManager.class.getCanonicalName());

    public CommandManager() {
        this.registerAnnotationProcessor(new RequirementsProcessor());
    }

    public void execute(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = command.getName().toLowerCase();
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(newArgs, sender, newMethodArgs);
    }

    private void executeHelp(String[] args, CommandSender sender) throws CommandException {
        if (!sender.hasPermission("citizens." + args[0] + ".help")) {
            throw new NoPermissionsException();
        }
        int page = 1;
        try {
            page = args.length == 3 ? Integer.parseInt(args[2]) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, args[0], args[2]);
        }
        this.sendHelp(sender, args[0], page);
    }

    private void executeMethod(String[] args, CommandSender sender, Object[] methodArgs) throws CommandException {
        String cmdName = args[0].toLowerCase();
        String modifier = args.length > 1 ? args[1] : "";
        boolean help = modifier.toLowerCase().equals("help");
        Method method = this.commands.get(cmdName + " " + modifier.toLowerCase());
        if (method == null && !help) {
            method = this.commands.get(cmdName + " *");
        }
        if (method == null && help) {
            this.executeHelp(args, sender);
            return;
        }
        if (method == null) {
            throw new UnhandledCommandException();
        }
        if (!this.serverCommands.contains(method) && sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        if (!this.hasPermission(method, sender)) {
            throw new NoPermissionsException();
        }
        Command cmd = method.getAnnotation(Command.class);
        CommandContext context = new CommandContext(sender, args);
        if (context.argsLength() < cmd.min()) {
            throw new CommandUsageException("citizens.commands.requirements.too-few-arguments", this.getUsage(args, cmd));
        }
        if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
            throw new CommandUsageException("citizens.commands.requirements.too-many-arguments", this.getUsage(args, cmd));
        }
        if (!cmd.flags().contains("*")) {
            for (char flag : context.getFlags()) {
                if (cmd.flags().indexOf(String.valueOf(flag)) != -1) continue;
                throw new CommandUsageException("Unknown flag: " + flag, this.getUsage(args, cmd));
            }
        }
        methodArgs[0] = context;
        for (Annotation annotation : this.registeredAnnotations.get((Object)method)) {
            CommandAnnotationProcessor processor = this.annotationProcessors.get(annotation.annotationType());
            processor.process(sender, context, annotation, methodArgs);
        }
        Object instance = this.instances.get(method);
        try {
            method.invoke(instance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e.getCause());
        }
    }

    public boolean executeSafe(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) {
        block9: {
            try {
                try {
                    this.execute(command, args, sender, methodArgs);
                }
                catch (ServerCommandException ex) {
                    Messaging.sendTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
                }
                catch (CommandUsageException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                    Messaging.sendError(sender, ex.getUsage());
                }
                catch (UnhandledCommandException ex) {
                    return false;
                }
                catch (WrappedCommandException ex) {
                    throw ex.getCause();
                }
                catch (CommandException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    Messaging.sendErrorTr(sender, "citizens.commands.invalid-number", new Object[0]);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!(sender instanceof Player)) break block9;
                Messaging.sendErrorTr(sender, "citizens.commands.console-error", new Object[0]);
                Messaging.sendError(sender, ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        return true;
    }

    public String getClosestCommandModifier(String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        command = command.toLowerCase();
        String closest = "";
        for (String cmd : this.commands.keySet()) {
            int distance;
            String[] split = cmd.split(" ");
            if (split.length <= 1 || !split[0].equals(command) || minDist <= (distance = CommandManager.getLevenshteinDistance(modifier, split[1]))) continue;
            minDist = distance;
            closest = split[1];
        }
        return closest;
    }

    public CommandInfo getCommand(String rootCommand, String modifier) {
        String joined = Joiner.on((char)' ').join((Object)rootCommand, (Object)modifier, new Object[0]);
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            Command commandAnnotation;
            if (!entry.getKey().equalsIgnoreCase(joined) || entry.getValue() == null || (commandAnnotation = entry.getValue().getAnnotation(Command.class)) == null) continue;
            return new CommandInfo(commandAnnotation);
        }
        return null;
    }

    public List<CommandInfo> getCommands(String command) {
        ArrayList cmds = Lists.newArrayList();
        command = command.toLowerCase();
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            Command commandAnnotation;
            if (!entry.getKey().startsWith(command) || entry.getValue() == null || (commandAnnotation = entry.getValue().getAnnotation(Command.class)) == null) continue;
            cmds.add(new CommandInfo(commandAnnotation));
        }
        return cmds;
    }

    private List<String> getLines(CommandSender sender, String baseCommand) {
        HashSet processed = Sets.newHashSet();
        ArrayList<String> lines = new ArrayList<String>();
        for (CommandInfo info : this.getCommands(baseCommand)) {
            Command command = info.getCommandAnnotation();
            if (processed.contains(info) || !sender.hasPermission("citizens.admin") && !sender.hasPermission("citizens." + command.permission())) continue;
            lines.add(CommandManager.format(command, baseCommand));
            if (command.modifiers().length <= 1) continue;
            processed.add(info);
        }
        return lines;
    }

    private String getUsage(String[] args, Command cmd) {
        return "/" + (args[0] + " ") + cmd.usage();
    }

    public boolean hasCommand(org.bukkit.command.Command cmd, String modifier) {
        String cmdName = cmd.getName().toLowerCase();
        return this.commands.containsKey(cmdName + " " + modifier.toLowerCase()) || this.commands.containsKey(cmdName + " *");
    }

    private boolean hasPermission(CommandSender sender, String perm) {
        return sender.hasPermission(perm);
    }

    private boolean hasPermission(Method method, CommandSender sender) {
        Command cmd = method.getAnnotation(Command.class);
        return cmd.permission().isEmpty() || this.hasPermission(sender, cmd.permission()) || this.hasPermission(sender, "admin");
    }

    public void register(Class<?> clazz) {
        this.registerMethods(clazz, null);
    }

    public void registerAnnotationProcessor(CommandAnnotationProcessor processor) {
        this.annotationProcessors.put(processor.getAnnotationClass(), processor);
    }

    private void registerMethods(Class<?> clazz, Method parent) {
        Object obj = this.injector != null ? this.injector.getInstance(clazz) : null;
        this.registerMethods(clazz, parent, obj);
    }

    private void registerMethods(Class<?> clazz, Method parent, Object obj) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.isAnnotationPresent(Command.class)) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                if (obj == null) continue;
                this.instances.put(method, obj);
            }
            Command cmd = method.getAnnotation(Command.class);
            for (String alias : cmd.aliases()) {
                for (String modifier : cmd.modifiers()) {
                    this.commands.put(alias + " " + modifier, method);
                }
                if (this.commands.containsKey(alias + " help")) continue;
                this.commands.put(alias + " help", null);
            }
            ArrayList annotations = Lists.newArrayList();
            for (Annotation annotation : method.getDeclaringClass().getAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(annotationClass)) continue;
                annotations.add(annotation);
            }
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(annotationClass)) continue;
                Iterator itr = annotations.iterator();
                while (itr.hasNext()) {
                    Annotation previous = (Annotation)itr.next();
                    if (previous.annotationType() != annotationClass) continue;
                    itr.remove();
                }
                annotations.add(annotation);
            }
            if (annotations.size() > 0) {
                this.registeredAnnotations.putAll((Object)method, (Iterable)annotations);
            }
            if ((parameterTypes = method.getParameterTypes()).length > 1 && parameterTypes[1] != CommandSender.class) continue;
            this.serverCommands.add(method);
        }
    }

    private void sendHelp(CommandSender sender, String name, int page) throws CommandException {
        if (name.equalsIgnoreCase("npc")) {
            name = "NPC";
        }
        Paginator paginator = new Paginator().header(CommandManager.capitalize(name) + " " + Messaging.tr("citizens.commands.help.header", new Object[0]));
        for (String line : this.getLines(sender, name.toLowerCase())) {
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", page);
        }
    }

    private void sendSpecificHelp(CommandSender sender, String rootCommand, String modifier) throws CommandException {
        CommandInfo info = this.getCommand(rootCommand, modifier);
        if (info == null) {
            throw new CommandException("citizens.commands.help.command-missing", rootCommand + " " + modifier);
        }
        Messaging.send(sender, CommandManager.format(info.getCommandAnnotation(), rootCommand));
        String help = Messaging.tryTranslate(info.getCommandAnnotation().help());
        if (help.isEmpty()) {
            return;
        }
        Messaging.send(sender, ChatColor.AQUA + help);
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    private static String capitalize(Object string) {
        String capitalize = string.toString();
        return capitalize.length() == 0 ? "" : Character.toUpperCase(capitalize.charAt(0)) + capitalize.substring(1, capitalize.length());
    }

    private static String format(Command command, String alias) {
        return String.format(COMMAND_FORMAT, alias, command.usage().isEmpty() ? "" : " " + command.usage(), Messaging.tryTranslate(command.desc()));
    }

    private static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static class CommandInfo {
        private final Command commandAnnotation;

        public CommandInfo(Command commandAnnotation) {
            this.commandAnnotation = commandAnnotation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CommandInfo other = (CommandInfo)obj;
            return !(this.commandAnnotation == null ? other.commandAnnotation != null : !this.commandAnnotation.equals(other.commandAnnotation));
        }

        public Command getCommandAnnotation() {
            return this.commandAnnotation;
        }

        public int hashCode() {
            return 31 + (this.commandAnnotation == null ? 0 : this.commandAnnotation.hashCode());
        }
    }
}

