/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Callables;
import java.util.concurrent.Callable;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.Script;

public class ObjectProvider
implements ContextProvider {
    private final String name;
    private final Callable<Object> provider;

    public ObjectProvider(String name, Callable<Object> provider) {
        Preconditions.checkNotNull(provider, (Object)"provider cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.name = name;
        this.provider = provider;
    }

    public ObjectProvider(String name, Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"provided object cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.name = name;
        this.provider = Callables.returning((Object)obj);
    }

    @Override
    public void provide(Script script) {
        Object res = null;
        try {
            res = this.provider.call();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res == null) {
            return;
        }
        script.setAttribute(this.name, res);
    }
}

