/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util.prtree;

import net.citizensnpcs.api.util.prtree.DistanceCalculator;
import net.citizensnpcs.api.util.prtree.MBR;
import net.citizensnpcs.api.util.prtree.MBRConverter;
import net.citizensnpcs.api.util.prtree.NodeFilter;
import net.citizensnpcs.api.util.prtree.PointND;
import org.bukkit.util.Vector;

public class Region3D<T>
implements MBR {
    private final T data;
    private final Vector min;
    private final Vector max;

    public Region3D(Vector min, Vector max, T data) {
        this.min = min;
        this.max = max;
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    @Override
    public int getDimensions() {
        return 3;
    }

    @Override
    public double getMax(int axis) {
        switch (axis) {
            case 0: {
                return this.max.getBlockX();
            }
            case 1: {
                return this.max.getBlockY();
            }
            case 2: {
                return this.max.getBlockZ();
            }
        }
        return 0.0;
    }

    @Override
    public double getMin(int axis) {
        switch (axis) {
            case 0: {
                return this.min.getBlockX();
            }
            case 1: {
                return this.min.getBlockY();
            }
            case 2: {
                return this.min.getBlockZ();
            }
        }
        return 0.0;
    }

    public <I> boolean intersects(I t, MBRConverter<I> converter) {
        converter.getMin(this.getDimensions(), t);
        return false;
    }

    @Override
    public boolean intersects(MBR other) {
        if (other.getMax(0) < (double)this.min.getBlockX() || other.getMax(1) < (double)this.min.getBlockY() || other.getMax(2) < (double)this.min.getBlockZ()) {
            return false;
        }
        if (other.getMin(0) > (double)this.max.getBlockX() || other.getMin(1) > (double)this.max.getBlockY() || other.getMin(2) > (double)this.max.getBlockZ()) {
            return false;
        }
        return false;
    }

    @Override
    public MBR union(MBR mbr) {
        Vector umin = new Vector(Math.min(this.min.getX(), mbr.getMin(0)), Math.min(this.min.getY(), mbr.getMin(1)), Math.min(this.min.getZ(), mbr.getMin(2)));
        Vector umax = new Vector(Math.max(this.max.getX(), mbr.getMax(0)), Math.max(this.max.getY(), mbr.getMax(1)), Math.max(this.max.getZ(), mbr.getMax(2)));
        return new Region3D<T>(umin, umax, this.data);
    }

    public static <T> DistanceCalculator<Region3D<T>> distanceCalculator() {
        return new DistanceCalculator<Region3D<T>>(){

            @Override
            public double distanceTo(Region3D<T> t, PointND p) {
                double x = p.getOrd(0);
                double y = p.getOrd(1);
                double z = p.getOrd(2);
                return Math.sqrt(Math.pow(x - (t.getMin(0) + t.getMax(0)) / 2.0, 2.0) + Math.pow(y - (t.getMin(1) + t.getMax(1)) / 2.0, 2.0) + Math.pow(z - (t.getMin(2) + t.getMax(2)) / 2.0, 2.0));
            }
        };
    }

    public static <T> NodeFilter<Region3D<T>> alwaysAcceptNodeFilter() {
        return new NodeFilter<Region3D<T>>(){

            @Override
            public boolean accept(Region3D<T> t) {
                return true;
            }
        };
    }

    public static class Converter<C>
    implements MBRConverter<Region3D<C>> {
        @Override
        public int getDimensions() {
            return 3;
        }

        @Override
        public double getMax(int axis, Region3D<C> t) {
            return t.getMax(axis);
        }

        @Override
        public double getMin(int axis, Region3D<C> t) {
            return t.getMin(axis);
        }
    }
}

