/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class FlyingBlockExaminer
implements BlockExaminer {
    private static final Vector UP = new Vector(0, 1, 0);

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material in = source.getMaterialAt(pos);
        if (above == Material.WEB || in == Material.WEB) {
            return 1.0f;
        }
        return 0.5f;
    }

    @Override
    public boolean isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material in = source.getMaterialAt(pos);
        if (MinecraftBlockExaminer.isLiquid(above, in)) {
            return false;
        }
        return MinecraftBlockExaminer.canStandIn(above, in);
    }
}

