/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorNode
extends AStarNode
implements PathPoint {
    private float blockCost = -1.0f;
    private final BlockSource blockSource;
    List<PathPoint.PathCallback> callbacks;
    private final BlockExaminer[] examiners;
    private final VectorGoal goal;
    Vector location;
    private static final float TIEBREAKER = 1.001f;

    public VectorNode(VectorGoal goal, Location location, BlockSource source, BlockExaminer ... examiners) {
        this(goal, location.toVector(), source, examiners);
    }

    public VectorNode(VectorGoal goal, Vector location, BlockSource source, BlockExaminer ... examiners) {
        this.location = location.setX(location.getBlockX()).setY(location.getBlockY()).setZ(location.getBlockZ());
        this.blockSource = source;
        this.examiners = examiners == null ? new BlockExaminer[]{} : examiners;
        this.goal = goal;
    }

    @Override
    public void addCallback(PathPoint.PathCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = Lists.newArrayList();
        }
        this.callbacks.add(callback);
    }

    @Override
    public Plan buildPlan() {
        Iterable<VectorNode> parents = this.getParents();
        return new Path(parents);
    }

    public float distance(VectorNode to) {
        return (float)this.location.distance(to.location);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VectorNode other = (VectorNode)obj;
        return !(this.location == null ? other.location != null : !this.location.equals((Object)other.location));
    }

    private float getBlockCost() {
        if (this.blockCost == -1.0f) {
            this.blockCost = 0.0f;
            for (BlockExaminer examiner : this.examiners) {
                this.blockCost += examiner.getCost(this.blockSource, this);
            }
        }
        return this.blockCost;
    }

    @Override
    public Vector getGoal() {
        return this.goal.goal;
    }

    @Override
    public Iterable<AStarNode> getNeighbours() {
        ArrayList nodes = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    VectorNode sub;
                    Vector mod;
                    if (x == 0 && y == 0 && z == 0 || x != 0 && z != 0 || (mod = this.location.clone().add(new Vector(x, y, z))).equals((Object)this.location) || !this.isPassable(sub = this.getNewNode(mod))) continue;
                    nodes.add(sub);
                }
            }
        }
        return nodes;
    }

    private VectorNode getNewNode(Vector mod) {
        return new VectorNode(this.goal, mod, this.blockSource, this.examiners);
    }

    @Override
    public PathPoint getParentPoint() {
        return (PathPoint)((Object)this.getParent());
    }

    @Override
    public Vector getVector() {
        return this.location;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 + (this.location == null ? 0 : this.location.hashCode());
    }

    public float heuristicDistance(Vector goal) {
        return (float)(this.location.distance(goal) + (double)this.getBlockCost()) * 1.001f;
    }

    private boolean isPassable(PathPoint mod) {
        boolean passable = true;
        for (BlockExaminer examiner : this.examiners) {
            BlockExaminer.PassableState state = examiner.isPassable(this.blockSource, mod);
            if (state == BlockExaminer.PassableState.IGNORE) continue;
            passable = state == BlockExaminer.PassableState.PASSABLE;
        }
        return passable;
    }

    @Override
    public void setVector(Vector vector) {
        this.location = vector;
    }
}

