/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemStorage {
    private static Iterable<Color> deserialiseColors(DataKey key) {
        ArrayList colors = Lists.newArrayList();
        for (DataKey sub : key.getIntegerSubKeys()) {
            colors.add(Color.fromRGB((int)sub.getInt("rgb")));
        }
        return colors;
    }

    private static Map<Enchantment, Integer> deserialiseEnchantments(DataKey root, ItemStack res) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (DataKey subKey : root.getSubKeys()) {
            Enchantment enchantment = null;
            try {
                enchantment = Enchantment.getById((int)Integer.parseInt(subKey.name()));
            }
            catch (NumberFormatException ex) {
                enchantment = Enchantment.getByName((String)subKey.name());
            }
            if (enchantment == null || !enchantment.canEnchantItem(res)) continue;
            int level = Math.min(subKey.getInt(""), enchantment.getMaxLevel());
            enchantments.put(enchantment, level);
        }
        return enchantments;
    }

    private static FireworkEffect deserialiseFireworkEffect(DataKey key) {
        FireworkEffect.Builder effect = FireworkEffect.builder();
        effect.flicker(key.getBoolean("flicker"));
        effect.trail(key.getBoolean("trail"));
        effect.with(FireworkEffect.Type.valueOf((String)key.getString("type")));
        effect.withColor(ItemStorage.deserialiseColors(key.getRelative("colors")));
        effect.withFade(ItemStorage.deserialiseColors(key.getRelative("fadecolors")));
        return effect.build();
    }

    private static void deserialiseMeta(DataKey root, ItemStack res) {
        Object meta;
        if (root.keyExists("lore")) {
            meta = ItemStorage.ensureMeta(res);
            ArrayList lore = Lists.newArrayList();
            for (DataKey key : root.getRelative("lore").getIntegerSubKeys()) {
                lore.add(key.getString(""));
            }
            meta.setLore((List)lore);
            res.setItemMeta(meta);
        }
        if (root.keyExists("displayname")) {
            meta = ItemStorage.ensureMeta(res);
            meta.setDisplayName(root.getString("displayname"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("firework")) {
            meta = (FireworkMeta)ItemStorage.ensureMeta(res);
            for (DataKey sub : root.getRelative("firework.effects").getIntegerSubKeys()) {
                meta.addEffect(ItemStorage.deserialiseFireworkEffect(sub));
            }
            meta.setPower(root.getInt("firework.power"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("book")) {
            meta = (BookMeta)ItemStorage.ensureMeta(res);
            for (DataKey sub : root.getRelative("book.pages").getIntegerSubKeys()) {
                meta.addPage(new String[]{sub.getString("")});
            }
            meta.setTitle(root.getString("book.title"));
            meta.setAuthor(root.getString("book.author"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("armor")) {
            meta = (LeatherArmorMeta)ItemStorage.ensureMeta(res);
            meta.setColor(Color.fromRGB((int)root.getInt("armor.color")));
            res.setItemMeta(meta);
        }
        if (root.keyExists("map")) {
            meta = (MapMeta)ItemStorage.ensureMeta(res);
            meta.setScaling(root.getBoolean("map.scaling"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("skull")) {
            meta = (SkullMeta)ItemStorage.ensureMeta(res);
            meta.setOwner(root.getString("skull.owner"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("potion")) {
            meta = (PotionMeta)ItemStorage.ensureMeta(res);
            for (DataKey sub : root.getRelative("potion.effects").getIntegerSubKeys()) {
                int duration = sub.getInt("duration");
                int amplifier = sub.getInt("amplifier");
                PotionEffectType type = PotionEffectType.getByName((String)sub.getString("type"));
                boolean ambient = sub.getBoolean("ambient");
                meta.addCustomEffect(new PotionEffect(type, duration, amplifier, ambient), true);
            }
            res.setItemMeta(meta);
        }
    }

    private static <T extends ItemMeta> T ensureMeta(ItemStack stack) {
        if (!stack.hasItemMeta()) {
            stack.setItemMeta(Bukkit.getServer().getItemFactory().getItemMeta(stack.getType()));
        }
        return (T)stack.getItemMeta();
    }

    public static ItemStack loadItemStack(DataKey root) {
        String raw = root.getString("type", root.getString("id"));
        if (raw == null || raw.length() == 0) {
            return null;
        }
        Material material = Material.matchMaterial((String)raw);
        if (material == null) {
            return null;
        }
        ItemStack res = new ItemStack(material, root.getInt("amount"), (short)root.getInt("durability", root.getInt("data", 0)));
        if (root.keyExists("mdata") && res.getData() != null) {
            res.getData().setData((byte)root.getInt("mdata"));
        }
        if (root.keyExists("enchantments")) {
            Map<Enchantment, Integer> enchantments = ItemStorage.deserialiseEnchantments(root.getRelative("enchantments"), res);
            res.addEnchantments(enchantments);
        }
        ItemStorage.deserialiseMeta(root.getRelative("meta"), res);
        return res;
    }

    private static void migrateForSave(DataKey key) {
        key.removeKey("data");
        key.removeKey("id");
    }

    public static void saveItem(DataKey key, ItemStack item) {
        if (item == null) {
            return;
        }
        ItemStorage.migrateForSave(key);
        key.setString("type", item.getType().name());
        key.setInt("amount", item.getAmount());
        key.setInt("durability", item.getDurability());
        if (item.getData() != null) {
            key.setInt("mdata", item.getData().getData());
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            ItemStorage.serialiseMeta(key.getRelative("meta"), meta);
        } else {
            key.removeKey("meta");
        }
        ItemStorage.serialiseEnchantments(key.getRelative("enchantments"), item.getEnchantments());
    }

    private static void serialiseColors(DataKey key, List<Color> colors) {
        for (int i = 0; i < colors.size(); ++i) {
            Color color = colors.get(i);
            key.getRelative(i).setInt("rgb", color.asRGB());
        }
    }

    private static void serialiseEnchantments(DataKey key, Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> enchantment : enchantments.entrySet()) {
            key.setInt(enchantment.getKey().getName(), enchantment.getValue());
        }
    }

    private static void serialiseFireworkEffect(DataKey key, FireworkEffect effect) {
        key.setBoolean("trail", effect.hasTrail());
        key.setBoolean("flicker", effect.hasFlicker());
        key.setString("type", effect.getType().name());
        ItemStorage.serialiseColors(key.getRelative("colors"), effect.getColors());
        ItemStorage.serialiseColors(key.getRelative("fadecolors"), effect.getFadeColors());
    }

    private static void serialiseMeta(DataKey key, ItemMeta meta) {
        int i;
        if (meta.hasLore()) {
            List lore = meta.getLore();
            DataKey root = key.getRelative("lore");
            for (i = 0; i < lore.size(); ++i) {
                root.setString(Integer.toString(i), (String)lore.get(i));
            }
        } else {
            key.removeKey("lore");
        }
        if (meta.hasDisplayName()) {
            key.setString("displayname", meta.getDisplayName());
        } else {
            key.removeKey("displayname");
        }
        if (meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            DataKey pages = key.getRelative("book.pages");
            for (i = 1; i <= book.getPageCount(); ++i) {
                pages.setString(Integer.toString(i), book.getPage(i));
            }
            key.setString("book.title", book.getTitle());
            key.setString("book.author", book.getAuthor());
            ItemStorage.serialiseEnchantments(key.getRelative("book.enchantments"), book.getEnchants());
        } else {
            key.removeKey("book");
        }
        if (meta instanceof SkullMeta) {
            SkullMeta skull = (SkullMeta)meta;
            key.setString("skull.owner", skull.getOwner());
        } else {
            key.removeKey("skull");
        }
        if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            int i2 = 0;
            for (FireworkEffect effect : firework.getEffects()) {
                ItemStorage.serialiseFireworkEffect(key.getRelative("firework.effects." + i2), effect);
                ++i2;
            }
            key.setInt("firework.power", firework.getPower());
        } else {
            key.removeKey("firework");
        }
        if (meta instanceof MapMeta) {
            MapMeta map = (MapMeta)meta;
            key.setBoolean("map.scaling", map.isScaling());
        } else {
            key.removeKey("map");
        }
        if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta armor = (LeatherArmorMeta)meta;
            Color color = armor.getColor();
            key.setInt("armor.color", color.asRGB());
        } else {
            key.removeKey("armor");
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            List effects = potion.getCustomEffects();
            DataKey effectKey = key.getRelative("potion.effects");
            for (int i3 = 0; i3 < effects.size(); ++i3) {
                PotionEffect effect = (PotionEffect)effects.get(i3);
                DataKey sub = effectKey.getRelative(Integer.toString(i3));
                sub.setBoolean("ambient", effect.isAmbient());
                sub.setInt("amplifier", effect.getAmplifier());
                sub.setInt("duration", effect.getDuration());
                sub.setString("type", effect.getType().getName());
            }
        } else {
            key.removeKey("potion");
        }
    }
}

