/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.Arrays;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.ItemStack;

public class Inventory
extends Trait {
    private ItemStack[] contents = new ItemStack[72];

    public Inventory() {
        super("inventory");
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.contents = this.parseContents(key);
    }

    @Override
    public void onSpawn() {
        this.setContents(this.contents);
    }

    private ItemStack[] parseContents(DataKey key) throws NPCLoadException {
        ItemStack[] contents = new ItemStack[72];
        for (DataKey slotKey : key.getIntegerSubKeys()) {
            contents[Integer.parseInt((String)slotKey.name())] = ItemStorage.loadItemStack(slotKey);
        }
        return contents;
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Player) {
            this.contents = ((Player)this.npc.getEntity()).getInventory().getContents();
        }
    }

    @Override
    public void save(DataKey key) {
        int slot = 0;
        for (ItemStack item : this.contents) {
            key.removeKey(String.valueOf(slot));
            if (item != null) {
                ItemStorage.saveItem(key.getRelative(String.valueOf(slot)), item);
            }
            ++slot;
        }
    }

    public void setContents(ItemStack[] contents) {
        this.contents = Arrays.copyOf(contents, 72);
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).getInventory().setContents(Arrays.copyOf(this.contents, 36));
        } else if (this.npc.getEntity() instanceof StorageMinecart) {
            ((StorageMinecart)this.npc.getEntity()).getInventory().setContents(this.contents);
        } else if (this.npc.getEntity() instanceof Horse) {
            ((Horse)this.npc.getEntity()).getInventory().setContents(Arrays.copyOf(this.contents, ((Horse)this.npc.getEntity()).getInventory().getSize()));
            ((Horse)this.npc.getEntity()).getInventory().setSaddle(this.contents[0]);
            ((Horse)this.npc.getEntity()).getInventory().setArmor(this.contents[1]);
        }
    }

    public String toString() {
        return "Inventory{" + Arrays.toString(this.contents) + "}";
    }
}

