/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public abstract class Composite
extends BehaviorGoalAdapter {
    private final List<Behavior> behaviors;
    private final List<Behavior> parallel = Lists.newArrayListWithCapacity((int)0);
    private final Set<Behavior> parallelExecuting = Sets.newHashSetWithExpectedSize((int)0);

    public Composite(Behavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    public Composite(Collection<Behavior> behaviors) {
        this.behaviors = Lists.newArrayList(behaviors);
        Iterator<Behavior> itr = this.behaviors.iterator();
        while (itr.hasNext()) {
            Behavior b = itr.next();
            if (!(b instanceof ParallelBehavior)) continue;
            this.parallel.add(b);
            itr.remove();
        }
    }

    public void addBehavior(Behavior behavior) {
        this.behaviors.add(behavior);
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    protected void prepareForExecution(Behavior behavior) {
        if (behavior == null) {
            return;
        }
        CitizensAPI.registerEvents(behavior);
    }

    public void removeBehavior(Behavior behavior) {
        this.behaviors.remove(behavior);
    }

    @Override
    public void reset() {
        if (this.parallelExecuting.size() > 0) {
            for (Behavior behavior : this.parallelExecuting) {
                this.stopExecution(behavior);
            }
            this.parallelExecuting.clear();
        }
    }

    @Override
    public boolean shouldExecute() {
        return this.behaviors.size() > 0;
    }

    protected void stopExecution(Behavior behavior) {
        if (behavior == null) {
            return;
        }
        HandlerList.unregisterAll((Listener)behavior);
        behavior.reset();
    }

    protected void tickParallel() {
        for (Behavior b : this.parallel) {
            this.tryAddParallel(b);
        }
        Iterator<Behavior> itr = this.parallelExecuting.iterator();
        while (itr.hasNext()) {
            Behavior behavior = itr.next();
            BehaviorStatus status = behavior.run();
            switch (status) {
                case RESET_AND_REMOVE: {
                    this.behaviors.remove(behavior);
                }
                case FAILURE: 
                case SUCCESS: {
                    itr.remove();
                    this.stopExecution(behavior);
                    break;
                }
            }
        }
    }

    private void tryAddParallel(Behavior behavior) {
        if (behavior.shouldExecute() && !this.parallelExecuting.contains(behavior)) {
            this.parallelExecuting.add(behavior);
            this.prepareForExecution(behavior);
        }
    }
}

