/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorGoal
implements AStarGoal<VectorNode> {
    final Vector goal;
    private final float leeway;

    public VectorGoal(Location dest, float range) {
        if (!MinecraftBlockExaminer.canStandIn(dest.getBlock().getType())) {
            dest = MinecraftBlockExaminer.findValidLocation(dest, 1);
        }
        this.leeway = range;
        this.goal = dest.toVector();
        this.goal.setX(this.goal.getBlockX()).setY(this.goal.getBlockY()).setZ(this.goal.getBlockZ());
    }

    @Override
    public float g(VectorNode from, VectorNode to) {
        return from.distance(to);
    }

    @Override
    public float getInitialCost(VectorNode node) {
        return (float)node.getVector().distance(this.goal);
    }

    @Override
    public float h(VectorNode from) {
        return from.heuristicDistance(this.goal);
    }

    @Override
    public boolean isFinished(VectorNode node) {
        double distanceSquared = node.getVector().distanceSquared(this.goal);
        return this.goal.equals((Object)node.location) || distanceSquared <= (double)this.leeway;
    }
}

