/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportStuckAction
implements StuckAction {
    public static TeleportStuckAction INSTANCE = new TeleportStuckAction();
    private static final int MAX_ITERATIONS = 10;
    private static final double RANGE = 10.0;

    private TeleportStuckAction() {
    }

    private boolean canStand(Block block) {
        return MinecraftBlockExaminer.canStandIn(block.getType()) && MinecraftBlockExaminer.canStandIn(block.getRelative(BlockFace.UP).getType());
    }

    @Override
    public boolean run(NPC npc, Navigator navigator) {
        if (!npc.isSpawned()) {
            return false;
        }
        Location base = navigator.getTargetAsLocation();
        if (npc.getEntity().getLocation().distanceSquared(base) <= 10.0) {
            return true;
        }
        Block block = base.getBlock();
        int iterations = 0;
        while (!this.canStand(block)) {
            if (iterations++ >= 10) {
                block = base.getBlock();
                break;
            }
            block = block.getRelative(BlockFace.UP);
        }
        npc.teleport(block.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        return false;
    }
}

