/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;

public class RadiusNPCFlock
implements NPCFlock {
    private Collection<NPC> cached;
    private int cacheTicks = 0;
    private final int maxCacheTicks;
    private final double radius;

    public RadiusNPCFlock(double radius) {
        this(radius, 30);
    }

    public RadiusNPCFlock(double radius, int maxCacheTicks) {
        this.radius = radius;
        this.maxCacheTicks = maxCacheTicks;
    }

    @Override
    public Collection<NPC> getNearby(NPC npc) {
        if (this.cached != null && this.cacheTicks++ < this.maxCacheTicks) {
            return this.cached;
        }
        this.cached = null;
        this.cacheTicks = 0;
        ArrayList ret = Lists.newArrayList();
        for (Entity entity : npc.getEntity().getNearbyEntities(this.radius, this.radius, this.radius)) {
            NPC npc2 = CitizensAPI.getNPCRegistry().getNPC(entity);
            if (npc2 == null || !npc2.getNavigator().isNavigating()) continue;
            ret.add(npc2);
        }
        this.cached = ret;
        return ret;
    }
}

