/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.NeighbourGeneratorBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class FlyingBlockExaminer
implements NeighbourGeneratorBlockExaminer {
    private static final Vector UP = new Vector(0, 1, 0);

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material in = source.getMaterialAt(pos);
        if (above == Material.WEB || in == Material.WEB) {
            return 0.5f;
        }
        return 0.0f;
    }

    @Override
    public List<PathPoint> getNeighbours(BlockSource source, PathPoint point) {
        ArrayList neighbours = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    neighbours.add(point.createAtOffset(point.getVector().add(new Vector(x, y, z))));
                }
            }
        }
        return neighbours;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material in = source.getMaterialAt(pos);
        if (MinecraftBlockExaminer.isLiquid(above, in)) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        return BlockExaminer.PassableState.fromBoolean(MinecraftBlockExaminer.canStandIn(above, in));
    }
}

