/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.util.Vector;

public class Flocker
implements Runnable {
    private final List<FlockBehavior> behaviors;
    private final NPCFlock flock;
    private double maxForce = 1.5;
    private final NPC npc;

    public Flocker(NPC npc, NPCFlock flock, FlockBehavior ... behaviors) {
        this.npc = npc;
        this.flock = flock;
        this.behaviors = Arrays.asList(behaviors);
    }

    @Override
    public void run() {
        Collection<NPC> nearby = this.flock.getNearby(this.npc);
        if (nearby.isEmpty()) {
            return;
        }
        Vector base = new Vector(0, 0, 0);
        for (FlockBehavior behavior : this.behaviors) {
            base.add(behavior.getVector(this.npc, nearby));
        }
        base = Flocker.clip(this.maxForce, base);
        this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().add(base));
    }

    public void setMaxForce(double maxForce) {
        this.maxForce = maxForce;
    }

    private static Vector clip(double max, Vector vector) {
        if (vector.length() > max) {
            return vector.normalize().multiply(max);
        }
        return vector;
    }
}

