/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationPersister
implements Persister<Location> {
    @Override
    public Location create(DataKey root) {
        if (!root.keyExists("world")) {
            return null;
        }
        World world = Bukkit.getWorld((String)root.getString("world"));
        double x = root.getDouble("x");
        double y = root.getDouble("y");
        double z = root.getDouble("z");
        float yaw = this.normalise(root.getDouble("yaw"));
        float pitch = this.normalise(root.getDouble("pitch"));
        return world == null ? new LazilyLoadedLocation(root.getString("world"), x, y, z, yaw, pitch) : new Location(world, x, y, z, yaw, pitch);
    }

    private float normalise(double double1) {
        return (float)(!Double.isFinite(double1) ? 0.0 : double1);
    }

    private double round(double z) {
        if (Double.isInfinite(z) || Double.isNaN(z)) {
            return z;
        }
        return new BigDecimal(z).setScale(4, RoundingMode.DOWN).doubleValue();
    }

    @Override
    public void save(Location location, DataKey root) {
        if (location.getWorld() != null) {
            root.setString("world", location.getWorld().getName());
        }
        root.setDouble("x", this.round(location.getX()));
        root.setDouble("y", this.round(location.getY()));
        root.setDouble("z", this.round(location.getZ()));
        root.setDouble("yaw", location.getYaw());
        root.setDouble("pitch", location.getPitch());
    }

    public static class LazilyLoadedLocation
    extends Location {
        private final String worldName;

        public LazilyLoadedLocation(String world, double x, double y, double z, float yaw, float pitch) {
            super(null, x, y, z, yaw, pitch);
            this.worldName = world;
        }

        public World getWorld() {
            if (super.getWorld() == null) {
                super.setWorld(Bukkit.getWorld((String)this.worldName));
            }
            return super.getWorld();
        }
    }
}

