/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.ListIterator;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;

public class DoorExaminer
implements BlockExaminer {
    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Material in = source.getMaterialAt(point.getVector());
        if (MinecraftBlockExaminer.isDoor(in)) {
            point.addCallback(new DoorOpener());
            return BlockExaminer.PassableState.PASSABLE;
        }
        return BlockExaminer.PassableState.IGNORE;
    }

    static class DoorOpener
    implements PathPoint.PathCallback {
        DoorOpener() {
        }

        @Override
        public void run(NPC npc, Block point, ListIterator<Block> path) {
            if (!MinecraftBlockExaminer.isDoor(point.getType())) {
                return;
            }
            if (npc.getStoredLocation().distanceSquared(point.getLocation().add(0.5, 0.0, 0.5)) > 4.0) {
                return;
            }
            BlockState state = point.getState();
            Door door = (Door)state.getData();
            boolean bottom = !door.isTopHalf();
            Block set = bottom ? point : point.getRelative(BlockFace.DOWN);
            state = set.getState();
            door = (Door)state.getData();
            door.setOpen(true);
            state.setData((MaterialData)door);
            state.update();
        }
    }
}

