/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.Direction;
import net.citizensnpcs.api.hpastar.HPACluster;
import net.citizensnpcs.api.hpastar.HPAGraphAStarNode;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;
import net.citizensnpcs.api.hpastar.Tile;
import org.bukkit.Location;
import org.bukkit.Material;

public class HPAGraph {
    private final BlockSource blockSource;
    public List<List<HPACluster>> clusters = Lists.newArrayList();

    public HPAGraph(BlockSource blockSource) {
        this.blockSource = blockSource;
    }

    public void addClustersAtDepth(int depth, List<HPACluster> other) {
        while (this.clusters.size() <= depth) {
            this.clusters.add(new ArrayList());
        }
        this.clusters.get(depth).addAll(other);
    }

    public void buildClusters(Tile[][][] tiles, int depth) {
        int clusterSize = (int)(2.0 * Math.pow(2.0, depth));
        HPACluster[][][] clusters = new HPACluster[16][16 / clusterSize][16 / clusterSize];
        if (depth > 0) {
            ArrayList<HPACluster> newClusters = new ArrayList<HPACluster>();
            for (int y = 0; y < tiles.length; ++y) {
                for (int ci = 0; ci < 16; ci += clusterSize) {
                    for (int cj = 0; cj < 16; cj += clusterSize) {
                        HPACluster cluster = new HPACluster(this, depth, clusterSize, y, ci, cj);
                        ArrayList<HPACluster> subClusters = new ArrayList<HPACluster>();
                        for (HPACluster other : this.clusters.get(depth - 1)) {
                            if (!cluster.contains(other)) continue;
                            subClusters.add(other);
                        }
                        cluster.buildFrom(subClusters);
                        newClusters.add(cluster);
                    }
                }
            }
            this.addClustersAtDepth(depth, newClusters);
            return;
        }
        for (int y = 0; y < tiles.length; ++y) {
            Tile[][] ylevel = tiles[y];
            for (int ci = 0; ci < 16; ci += clusterSize) {
                for (int cj = 0; cj < 16; cj += clusterSize) {
                    HPACluster cluster = new HPACluster(this, depth, clusterSize, y, ci, cj);
                    boolean add = false;
                    if (!add) {
                        // empty if block
                    }
                    clusters[y][ci / clusterSize][cj / clusterSize] = cluster;
                }
            }
        }
        ArrayList<HPACluster> clusterList = new ArrayList<HPACluster>();
        IdentityHashMap clusterMap = new IdentityHashMap();
        int[][] moves = new int[][]{{0, 1}, {1, 0}, {-1, 0}, {0, -1}};
        for (int y = 0; y < clusters.length; ++y) {
            for (int x = 0; x < 16 / clusterSize; ++x) {
                for (int z = 0; z < 16 / clusterSize; ++z) {
                    HPACluster base = clusters[y][x][z];
                    if (base == null) continue;
                    clusterList.add(base);
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int[] move : moves) {
                            HPACluster other;
                            int dx = move[0];
                            int dz = move[1];
                            if (y + dy < 0 || x + dx < 0 || z + dz < 0 || y + dy >= 16 || x + dx >= 16 / clusterSize || z + dz >= 16 / clusterSize || (other = clusters[y + dy][x + dx][z + dz]) == null || clusterMap.containsKey(base) && ((List)clusterMap.get(base)).contains(other)) continue;
                            Direction direction = null;
                            if (dx > 0) {
                                direction = Direction.EAST;
                            }
                            if (dx < 0) {
                                direction = Direction.WEST;
                            }
                            if (dz > 0) {
                                direction = Direction.NORTH;
                            }
                            if (dz < 0) {
                                direction = Direction.SOUTH;
                            }
                            base.connect(other, direction);
                            clusterMap.putIfAbsent(base, new ArrayList());
                            clusterMap.putIfAbsent(other, new ArrayList());
                            ((List)clusterMap.get(base)).add(other);
                            ((List)clusterMap.get(other)).add(base);
                        }
                    }
                }
            }
        }
        for (HPACluster cluster : clusterList) {
            cluster.connectIntra();
        }
        this.addClustersAtDepth(depth, clusterList);
    }

    private double dist(Location start, HPACluster cluster) {
        return Math.sqrt(Math.pow(start.getBlockX() - cluster.clusterX, 2.0) + Math.pow(start.getBlockZ() - cluster.clusterZ, 2.0) + Math.pow(start.getBlockY() - cluster.clusterY, 2.0));
    }

    public Plan findPath(Location start, Location goal) {
        ArrayList<HPACluster> clustersToClean = new ArrayList<HPACluster>();
        HPAGraphNode startNode = new HPAGraphNode(start.getBlockX(), start.getBlockY(), start.getBlockZ());
        HPAGraphNode goalNode = new HPAGraphNode(goal.getBlockX(), goal.getBlockY(), goal.getBlockZ());
        for (List<HPACluster> clusterLayer : this.clusters) {
            double minDistStart = Double.MAX_VALUE;
            double minDistGoal = Double.MAX_VALUE;
            HPACluster startCluster = null;
            HPACluster goalCluster = null;
            for (HPACluster cluster : clusterLayer) {
                double distStart = this.dist(start, cluster);
                double distGoal = this.dist(goal, cluster);
                if (minDistStart > distStart) {
                    startCluster = cluster;
                    minDistStart = distStart;
                }
                if (!(minDistGoal > distGoal)) continue;
                goalCluster = cluster;
                minDistGoal = distGoal;
            }
            startCluster.insert(startNode);
            goalCluster.insert(goalNode);
            clustersToClean.add(startCluster);
            clustersToClean.add(goalCluster);
        }
        AStarSolution sln = this.pathfind(startNode, goalNode, 0);
        System.out.println(":" + start + "->" + goal + "=" + sln.cost);
        for (HPACluster cluster : clustersToClean) {
            cluster.remove(startNode, goalNode);
        }
        return new Path(sln.convertToVectors());
    }

    AStarSolution pathfind(HPAGraphNode start, HPAGraphNode dest, int level) {
        HashMap<HPAGraphAStarNode, Float> open = new HashMap<HPAGraphAStarNode, Float>();
        HashMap<HPAGraphAStarNode, Float> closed = new HashMap<HPAGraphAStarNode, Float>();
        PriorityQueue<HPAGraphAStarNode> frontier = new PriorityQueue<HPAGraphAStarNode>();
        HPAGraphAStarNode startNode = new HPAGraphAStarNode(start, null);
        frontier.add(startNode);
        open.put(startNode, Float.valueOf(startNode.g));
        while (!frontier.isEmpty()) {
            HPAGraphAStarNode node = (HPAGraphAStarNode)frontier.poll();
            List<HPAGraphEdge> edges = node.node.getEdges(level);
            for (HPAGraphEdge edge : edges) {
                if (!edge.to.equals(dest)) continue;
                return new AStarSolution(node.reconstructSolution(), node.g);
            }
            if (start != node.node) {
                closed.put(node, Float.valueOf(node.g));
            }
            open.remove(node);
            for (HPAGraphEdge edge : edges) {
                HPAGraphAStarNode neighbour = new HPAGraphAStarNode(edge.to, edge);
                if (closed.containsKey(neighbour)) continue;
                neighbour.parent = node;
                neighbour.g = node.g + edge.weight;
                neighbour.h = (float)Math.sqrt(Math.pow(edge.to.x - dest.x, 2.0) + Math.pow(edge.to.z - dest.z, 2.0));
                if (open.containsKey(neighbour)) {
                    if (neighbour.g > ((Float)open.get(neighbour)).floatValue()) continue;
                    frontier.remove(neighbour);
                }
                open.put(neighbour, Float.valueOf(neighbour.g));
                frontier.add(neighbour);
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    public boolean walkable(int x, int y, int z) {
        Material in = this.blockSource.getMaterialAt(x, y, z);
        Material on = this.blockSource.getMaterialAt(x, y - 1, z);
        Material above = this.blockSource.getMaterialAt(x, y + 2, z);
        return MinecraftBlockExaminer.canStandOn(in) && MinecraftBlockExaminer.canStandIn(on) && MinecraftBlockExaminer.canStandIn(above);
    }
}

