/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.util.Messaging;

public class ScriptCompiler {
    private final WeakReference<ClassLoader> classLoader;
    private final ScriptEngineManager engineManager;
    private final Map<String, ScriptEngine> engines = Maps.newHashMap();
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        int n = 1;

        @Override
        public Thread newThread(Runnable r) {
            Thread created = new Thread(r, "Citizens Script Compiler #" + this.n++);
            return created;
        }
    });
    private final Function<File, ScriptSource> fileEngineConverter = new Function<File, ScriptSource>(){

        public ScriptSource apply(File file) {
            if (!file.isFile()) {
                return null;
            }
            String fileName = file.getName();
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            ScriptEngine engine = ScriptCompiler.this.loadEngine(extension);
            if (engine == null) {
                return null;
            }
            return new ScriptSource(file, engine);
        }
    };
    private final List<ContextProvider> globalContextProviders = Lists.newArrayList();
    private static final Map<String, ScriptFactory> CACHE = new MapMaker().weakValues().makeMap();
    private static boolean CLASSLOADER_OVERRIDE_ENABLED;
    private static Method GET_APPLICATION_CLASS_LOADER;
    private static Method GET_GLOBAL;
    private static Method INIT_APPLICATION_CLASS_LOADER;

    public ScriptCompiler(ClassLoader overrideClassLoader) {
        this.engineManager = new ScriptEngineManager(overrideClassLoader);
        this.classLoader = new WeakReference<ClassLoader>(overrideClassLoader);
    }

    public boolean canCompile(File file) {
        return this.fileEngineConverter.apply((Object)file) != null;
    }

    public CompileTaskBuilder compile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file should not be null");
        }
        ScriptSource source = (ScriptSource)this.fileEngineConverter.apply((Object)file);
        if (source == null) {
            throw new IllegalArgumentException("could not recognise file");
        }
        return new CompileTaskBuilder(source);
    }

    public CompileTaskBuilder compile(String src, String identifier, String extension) {
        if (src == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        return new CompileTaskBuilder(new ScriptSource(src, identifier, this.loadEngine(extension)));
    }

    public void interrupt() {
        this.executor.shutdownNow();
    }

    private ScriptEngine loadEngine(String extension) {
        ScriptEngine engine = this.engines.get(extension);
        if (engine != null) {
            return engine;
        }
        ScriptEngine search = null;
        if (extension.equals("js") || extension.equals("javascript")) {
            search = this.engineManager.getEngineByName("nashorn");
        }
        if (search == null) {
            search = this.engineManager.getEngineByExtension(extension);
        }
        if (!(search == null || search instanceof Compilable && search instanceof Invocable)) {
            search = null;
        } else if (search != null) {
            search = this.tryUpdateClassLoader(search);
        }
        this.engines.put(extension, search);
        ClassLoader cl = (ClassLoader)this.classLoader.get();
        if (cl != null) {
            this.updateSunClassLoader(cl);
        }
        return search;
    }

    public void registerGlobalContextProvider(ContextProvider provider) {
        if (!this.globalContextProviders.contains(provider)) {
            this.globalContextProviders.add(provider);
        }
    }

    public void run(String code, String extension) throws ScriptException {
        this.run(code, extension, null);
    }

    public void run(String code, String extension, Map<String, Object> vars) throws ScriptException {
        ScriptEngine engine = this.loadEngine(extension);
        if (engine == null) {
            throw new ScriptException("Couldn't load engine with extension " + extension);
        }
        SimpleScriptContext context = new SimpleScriptContext();
        if (vars != null) {
            context.setBindings(new SimpleBindings(vars), 100);
        }
        engine.eval(extension, (ScriptContext)context);
    }

    private ScriptEngine tryUpdateClassLoader(ScriptEngine search) {
        ScriptEngineFactory factory = search.getFactory();
        try {
            Method method = factory.getClass().getMethod("getScriptEngine", ClassLoader.class);
            ClassLoader loader = (ClassLoader)this.classLoader.get();
            if (loader == null) {
                return search;
            }
            return (ScriptEngine)method.invoke((Object)factory, this.classLoader.get());
        }
        catch (Exception e) {
            return search;
        }
    }

    private void updateSunClassLoader(ClassLoader cl) {
        if (!CLASSLOADER_OVERRIDE_ENABLED) {
            return;
        }
        try {
            Object global = GET_GLOBAL.invoke(null, new Object[0]);
            if (GET_APPLICATION_CLASS_LOADER.invoke(global, new Object[0]) == null) {
                INIT_APPLICATION_CLASS_LOADER.invoke(global, cl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Map access$900() {
        return CACHE;
    }

    static {
        try {
            Class<?> CONTEXT_FACTORY = Class.forName("sun.org.mozilla.javascript.internal.ContextFactory");
            GET_APPLICATION_CLASS_LOADER = CONTEXT_FACTORY.getDeclaredMethod("getApplicationClassLoader", new Class[0]);
            GET_APPLICATION_CLASS_LOADER.setAccessible(true);
            GET_GLOBAL = CONTEXT_FACTORY.getDeclaredMethod("getGlobal", new Class[0]);
            GET_GLOBAL.setAccessible(true);
            INIT_APPLICATION_CLASS_LOADER = CONTEXT_FACTORY.getDeclaredMethod("initApplicationClassLoader", ClassLoader.class);
            INIT_APPLICATION_CLASS_LOADER.setAccessible(true);
            CLASSLOADER_OVERRIDE_ENABLED = true;
        }
        catch (Exception e) {
            Messaging.debug("Unable to find Rhino classes - javascript scripts won't see non-CraftBukkit classes");
        }
    }

    private static class ScriptSource {
        private final ScriptEngine engine;
        private final File file;
        private final String identifier;
        private final String src;

        private ScriptSource(File file, ScriptEngine engine) {
            this.file = file;
            this.identifier = file.getAbsolutePath();
            this.engine = engine;
            this.src = null;
        }

        private ScriptSource(String src, String identifier, ScriptEngine engine) {
            this.src = src;
            this.identifier = identifier;
            this.engine = engine;
            this.file = null;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Reader getReader() throws FileNotFoundException {
            return this.file == null ? new StringReader(this.src) : new FileReader(this.file);
        }

        static /* synthetic */ ScriptEngine access$1000(ScriptSource x0) {
            return x0.engine;
        }
    }

    public class CompileTaskBuilder {
        private boolean cache;
        private final List<CompileCallback> callbacks = Lists.newArrayList();
        private final List<ContextProvider> contextProviders = Lists.newArrayList();
        private final ScriptSource engine;

        private CompileTaskBuilder(ScriptSource engine) {
            this.engine = engine;
        }

        public Future<ScriptFactory> beginWithFuture() {
            CompileTask task = new CompileTask(this);
            return ScriptCompiler.this.executor.submit(task);
        }

        public CompileTaskBuilder cache(boolean cache) {
            this.cache = cache;
            return this;
        }

        public CompileTaskBuilder withCallback(CompileCallback callback) {
            this.callbacks.add(callback);
            return this;
        }

        public CompileTaskBuilder withContextProvider(ContextProvider provider) {
            this.contextProviders.add(provider);
            return this;
        }
    }

    private class CompileTask
    implements Callable<ScriptFactory> {
        private final boolean cache;
        private final CompileCallback[] callbacks;
        private final ContextProvider[] contextProviders;
        private final ScriptSource engine;

        public CompileTask(CompileTaskBuilder builder) {
            ArrayList copy = Lists.newArrayList((Iterable)builder.contextProviders);
            copy.addAll(ScriptCompiler.this.globalContextProviders);
            this.contextProviders = copy.toArray(new ContextProvider[copy.size()]);
            this.callbacks = builder.callbacks.toArray(new CompileCallback[builder.callbacks.size()]);
            this.engine = builder.engine;
            this.cache = builder.cache;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ScriptFactory call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

