/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.UUID;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@TraitName(value="owner")
public class Owner
extends Trait {
    private String owner = "server";
    private UUID uuid = null;
    public static final String SERVER = "server";

    public Owner() {
        super("owner");
    }

    public String getOwner() {
        return this.owner;
    }

    public UUID getOwnerId() {
        return this.uuid;
    }

    public boolean isOwnedBy(CommandSender sender) {
        if (sender instanceof Player) {
            if (this.owner.equalsIgnoreCase(sender.getName())) {
                if (this.uuid == null) {
                    this.uuid = ((Player)sender).getUniqueId();
                } else if (this.uuid.equals(((Player)sender).getUniqueId())) {
                    return true;
                }
            }
            return sender.hasPermission("citizens.admin") || this.owner.equals(SERVER) && sender.hasPermission("citizens.admin");
        }
        return this.owner.equals(SERVER);
    }

    public boolean isOwnedBy(String name) {
        return this.owner.equalsIgnoreCase(name);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (key.keyExists("owner")) {
            this.owner = key.getString("owner");
            if (key.keyExists("uuid") && !key.getString("uuid").isEmpty()) {
                this.uuid = UUID.fromString(key.getString("uuid"));
            }
        } else {
            try {
                this.owner = key.getString("");
                this.uuid = null;
            }
            catch (Exception ex) {
                this.owner = SERVER;
                this.uuid = null;
                throw new NPCLoadException("Invalid owner.");
            }
        }
    }

    @Override
    public void save(DataKey key) {
        if (key.getString("") != null && !key.getString("").isEmpty()) {
            key.removeKey("");
        }
        key.setString("owner", this.owner);
        key.setString("uuid", this.uuid == null ? "" : this.uuid.toString());
    }

    public void setOwner(CommandSender sender) {
        this.owner = sender.getName();
        if (sender instanceof Player) {
            this.uuid = ((Player)sender).getUniqueId();
        }
    }

    public void setOwner(String owner) {
        this.setOwner(owner, null);
    }

    public void setOwner(String owner, UUID uuid) {
        this.owner = owner;
        this.uuid = uuid;
    }

    public String toString() {
        return "Owner{" + this.owner + "}";
    }
}

