/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class MinecraftBlockExaminer
implements BlockExaminer {
    private static final Set<Material> DOORS = EnumSet.of(Material.SPRUCE_DOOR, Material.BIRCH_DOOR, Material.JUNGLE_DOOR, Material.ACACIA_DOOR, Material.DARK_OAK_DOOR);
    private static final Vector DOWN = new Vector(0, -1, 0);
    private static final Set<Material> LIQUIDS = EnumSet.of(Material.WATER, Material.LAVA);
    private static final Set<Material> NOT_JUMPABLE = EnumSet.of(Material.SPRUCE_FENCE, Material.BIRCH_FENCE, Material.JUNGLE_FENCE, Material.ACACIA_FENCE, Material.DARK_OAK_FENCE);
    private static final Set<Material> UNWALKABLE = EnumSet.of(Material.AIR, Material.LAVA, Material.CACTUS);
    private static final Vector UP = new Vector(0, 1, 0);
    private static Material WEB;

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material below = source.getMaterialAt(pos.clone().add(DOWN));
        Material in = source.getMaterialAt(pos);
        if (above == WEB || in == WEB) {
            return 1.0f;
        }
        if (below == Material.SOUL_SAND || below == Material.ICE) {
            return 1.0f;
        }
        if (MinecraftBlockExaminer.isLiquid(above, below, in)) {
            return 0.5f;
        }
        return 0.0f;
    }

    private boolean isClimbable(Material mat) {
        return mat == Material.LADDER || mat == Material.VINE;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        if (pos.getBlockY() <= 0 || pos.getBlockY() >= 255) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material below = source.getMaterialAt(pos.clone().add(DOWN));
        Material in = source.getMaterialAt(pos);
        if (!below.isBlock() || !MinecraftBlockExaminer.canStandOn(below)) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        if (this.isClimbable(above) && this.isClimbable(in) || this.isClimbable(in) && this.isClimbable(below)) {
            point.addCallback(new LadderClimber());
        } else if (!MinecraftBlockExaminer.canStandIn(above) || !MinecraftBlockExaminer.canStandIn(in)) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        if (!MinecraftBlockExaminer.canJumpOn(below)) {
            if (point.getParentPoint() == null) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
            Vector parentPos = point.getParentPoint().getVector();
            if ((parentPos.getX() != pos.getX() || parentPos.getZ() != pos.getZ()) && pos.clone().subtract(point.getParentPoint().getVector()).getY() == 1.0) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
        }
        return BlockExaminer.PassableState.PASSABLE;
    }

    private static boolean canJumpOn(Material mat) {
        return !NOT_JUMPABLE.contains(mat);
    }

    public static boolean canStandIn(Material ... mat) {
        boolean passable = true;
        for (Material m : mat) {
            passable &= !m.isSolid();
        }
        return passable;
    }

    public static boolean canStandOn(Block block) {
        Block up = block.getRelative(BlockFace.UP);
        return MinecraftBlockExaminer.canStandOn(block.getType()) && MinecraftBlockExaminer.canStandIn(up.getType()) && MinecraftBlockExaminer.canStandIn(up.getRelative(BlockFace.UP).getType());
    }

    public static boolean canStandOn(Material mat) {
        return !UNWALKABLE.contains(mat) && mat.isSolid();
    }

    public static Location findRandomValidLocation(Location base, int xrange, int yrange) {
        return MinecraftBlockExaminer.findRandomValidLocation(base, xrange, yrange, null, new Random());
    }

    public static Location findRandomValidLocation(Location base, int xrange, int yrange, Function<Block, Boolean> filter) {
        return MinecraftBlockExaminer.findRandomValidLocation(base, xrange, yrange, filter, new Random());
    }

    public static Location findRandomValidLocation(Location base, int xrange, int yrange, Function<Block, Boolean> filter, Random random) {
        Location found = null;
        for (int i = 0; i < 10; ++i) {
            int x = base.getBlockX() + random.nextInt(2 * xrange) - xrange;
            int y = base.getBlockY() + random.nextInt(2 * yrange) - yrange;
            int z = base.getBlockZ() + random.nextInt(2 * xrange) - xrange;
            Block block = base.getWorld().getBlockAt(x, y, z);
            if (!MinecraftBlockExaminer.canStandOn(block) || filter != null && !filter.apply(block).booleanValue()) continue;
            found = block.getLocation().add(0.0, 1.0, 0.0);
            break;
        }
        return found;
    }

    public static Location findValidLocation(Location location, int radius) {
        Block base = location.getBlock();
        if (MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int y = 0; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    Block relative = base.getRelative(x, y, z);
                    if (!MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) continue;
                    return relative.getLocation();
                }
            }
        }
        return location;
    }

    public static Location findValidLocation(Location location, int radius, int yradius) {
        Block base = location.getBlock();
        if (MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int y = -yradius; y <= yradius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    Block relative = base.getRelative(x, y, z);
                    if (!MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) continue;
                    return relative.getLocation();
                }
            }
        }
        return location;
    }

    public static boolean isDoor(Material in) {
        return DOORS.contains(in);
    }

    public static boolean isLiquid(Material ... materials) {
        for (Material mat : materials) {
            if (!LIQUIDS.contains(mat)) continue;
            return true;
        }
        return false;
    }

    public static boolean validPosition(Block in) {
        return MinecraftBlockExaminer.canStandIn(in.getType()) && MinecraftBlockExaminer.canStandIn(in.getRelative(BlockFace.UP).getType()) && MinecraftBlockExaminer.canStandOn(in.getRelative(BlockFace.DOWN).getType());
    }

    static {
        Material material = WEB = SpigotUtil.isUsing1_13API() ? Material.COBWEB : Material.valueOf((String)"WEB");
        if (!SpigotUtil.isUsing1_13API()) {
            LIQUIDS.add(Material.valueOf((String)"STATIONARY_LAVA"));
            LIQUIDS.add(Material.valueOf((String)"STATIONARY_WATER"));
            UNWALKABLE.add(Material.valueOf((String)"STATIONARY_LAVA"));
            NOT_JUMPABLE.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"FENCE"), Material.valueOf((String)"IRON_FENCE"), Material.valueOf((String)"NETHER_FENCE"), Material.valueOf((String)"COBBLE_WALL")}));
            DOORS.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"IRON_DOOR_BLOCK"), Material.valueOf((String)"WOODEN_DOOR")}));
        } else {
            try {
                UNWALKABLE.add(Material.valueOf((String)"CAMPFIRE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            NOT_JUMPABLE.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"OAK_FENCE"), Material.valueOf((String)"NETHER_BRICK_FENCE"), Material.valueOf((String)"COBBLESTONE_WALL")}));
            DOORS.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"IRON_DOOR"), Material.valueOf((String)"OAK_DOOR")}));
        }
    }

    private class LadderClimber
    implements PathPoint.PathCallback {
        boolean added = false;
        ListIterator<Block> current;

        private LadderClimber() {
        }

        @Override
        public void run(final NPC npc, Block point, ListIterator<Block> path) {
            this.current = path;
            if (this.added || npc.data().get("running-ladder", false).booleanValue()) {
                this.added = true;
                return;
            }
            Runnable callback = new Runnable(){
                Location dummy = new Location(null, 0.0, 0.0, 0.0);

                @Override
                public void run() {
                    if (npc.getEntity().getLocation(this.dummy).getBlock().getType() == Material.LADDER && LadderClimber.this.current.next().getY() > LadderClimber.this.current.previous().getY()) {
                        npc.getEntity().setVelocity(npc.getEntity().getVelocity().setY(0.3));
                    }
                }
            };
            npc.getNavigator().getLocalParameters().addSingleUseCallback(new NavigatorCallback(){

                @Override
                public void onCompletion(CancelReason cancelReason) {
                    npc.data().set("running-ladder", false);
                }
            });
            npc.getNavigator().getLocalParameters().addRunCallback(callback);
            this.added = true;
        }
    }
}

