/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.EulerAnglePersister;
import net.citizensnpcs.api.persistence.ItemStackPersister;
import net.citizensnpcs.api.persistence.LocationPersister;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.persistence.UUIDPersister;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class PersistenceLoader {
    private static final Map<Class<?>, Field[]> fieldCache = new WeakHashMap();
    private static final Map<Class<? extends Persister<?>>, Persister<?>> loadedDelegates = new WeakHashMap();
    private static final Exception loadException = new Exception(){
        private static final long serialVersionUID = -4245839150826112365L;

        public void fillInStackTrace(StackTraceElement[] elements) {
        }
    };
    private static final Map<Class<?>, Class<? extends Persister<?>>> persistRedirects = new WeakHashMap();

    private static String createRelativeKey(String key, int ext) {
        return PersistenceLoader.createRelativeKey(key, Integer.toString(ext));
    }

    private static String createRelativeKey(String parent, String ext) {
        if (ext.isEmpty()) {
            return parent;
        }
        if (ext.charAt(0) == '.') {
            return parent.isEmpty() ? ext.substring(1, ext.length()) : parent + ext;
        }
        return parent.isEmpty() ? ext : parent + '.' + ext;
    }

    private static void deserialise(PersistField field, DataKey root) throws Exception {
        Object value;
        Class type = field.getType();
        Class<?> collectionType = field.getCollectionType();
        if (!Collection.class.isAssignableFrom(collectionType) && !Map.class.isAssignableFrom(collectionType)) {
            throw loadException;
        }
        if (List.class.isAssignableFrom(type)) {
            List list = !List.class.isAssignableFrom(collectionType) ? Lists.newArrayList() : collectionType.newInstance();
            Object raw = root.getRaw(field.key);
            if (raw instanceof List && collectionType.isAssignableFrom(raw.getClass())) {
                list = (List)raw;
            } else {
                PersistenceLoader.deserialiseCollection(list, root, field);
            }
            value = list;
        } else if (Set.class.isAssignableFrom(type)) {
            Set<Object> set = Set.class.isAssignableFrom(collectionType) ? (EnumSet<?>)collectionType.newInstance() : (field.getType().isEnum() ? EnumSet.noneOf(field.getType()) : (Set)(field.get() != null && Set.class.isAssignableFrom(field.get().getClass()) ? field.get().getClass().newInstance() : Sets.newHashSet()));
            Object raw = root.getRaw(field.key);
            if (raw instanceof Set && collectionType.isAssignableFrom(raw.getClass())) {
                set = (Set)raw;
            } else {
                PersistenceLoader.deserialiseCollection(set, root, field);
            }
            value = set;
        } else if (Map.class.isAssignableFrom(type)) {
            Map map;
            if (Map.class.isAssignableFrom(collectionType)) {
                map = (Map)collectionType.newInstance();
            } else {
                boolean hasConcreteType = field.get() != null && Map.class.isAssignableFrom(field.get().getClass()) && !field.get().getClass().isInterface();
                map = (Map)(hasConcreteType ? field.get() : Maps.newHashMap());
            }
            PersistenceLoader.deserialiseMap(map, root, field);
            value = map;
        } else if (float[].class.isAssignableFrom(type)) {
            ArrayList floats = Lists.newArrayList();
            for (DataKey sub : root.getRelative(field.key).getIntegerSubKeys()) {
                floats.add(Float.valueOf((float)sub.getDouble("")));
            }
            value = new float[floats.size()];
            for (int i = 0; i < floats.size(); ++i) {
                ((float[])value)[i] = ((Float)floats.get(i)).floatValue();
            }
        } else if (double[].class.isAssignableFrom(type)) {
            ArrayList doubles = Lists.newArrayList();
            for (DataKey sub : root.getRelative(field.key).getIntegerSubKeys()) {
                doubles.add(sub.getDouble(""));
            }
            value = new double[doubles.size()];
            for (int i = 0; i < doubles.size(); ++i) {
                ((double[])value)[i] = (Double)doubles.get(i);
            }
        } else if (int[].class.isAssignableFrom(type)) {
            ArrayList ints = Lists.newArrayList();
            for (DataKey sub : root.getRelative(field.key).getIntegerSubKeys()) {
                ints.add(sub.getInt(""));
            }
            value = new int[ints.size()];
            for (int i = 0; i < ints.size(); ++i) {
                ((int[])value)[i] = (Integer)ints.get(i);
            }
        } else {
            value = PersistenceLoader.deserialiseValue(field, root.getRelative(field.key));
        }
        if (value == null && field.isRequired()) {
            throw loadException;
        }
        if (type.isPrimitive() || Primitives.isWrapperType(type)) {
            Class<?> clazz;
            if (value == null) {
                return;
            }
            if (!Primitives.isWrapperType(type)) {
                type = Primitives.wrap(type);
            }
            if ((clazz = value.getClass()) == Integer.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            if (clazz == Float.class && type != Double.class && type != Float.class) {
                return;
            }
            if (clazz == Double.class && type != Double.class) {
                if (type == Float.class) {
                    value = Float.valueOf(((Double)value).floatValue());
                } else {
                    return;
                }
            }
            if (clazz == Byte.class && type != Short.class && type != Byte.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            if (clazz == Short.class && type != Short.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            if (clazz == Character.class && type != Character.class && type != Short.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            field.set(value);
        } else {
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                return;
            }
            field.set(value);
        }
    }

    private static void deserialiseCollection(Collection<Object> collection, DataKey root, PersistField field) {
        for (DataKey subKey : root.getRelative(field.key).getSubKeys()) {
            Object loaded = PersistenceLoader.deserialiseCollectionValue(field, subKey, field.persistAnnotation.valueType());
            if (loaded == null) continue;
            collection.add(loaded);
        }
    }

    private static Object deserialiseCollectionValue(PersistField field, DataKey subKey, Class<?> type) {
        Object deserialised = PersistenceLoader.deserialiseValue(field, subKey);
        if (deserialised == null || type == Object.class) {
            return deserialised;
        }
        Class clazz = deserialised.getClass();
        if (type.isPrimitive() || Primitives.isWrapperType(type)) {
            if (!Primitives.isWrapperType(clazz)) {
                clazz = Primitives.wrap(clazz);
            }
            if (type != clazz) {
                if (type == Long.class) {
                    return ((Number)deserialised).longValue();
                }
                if (type == Byte.class) {
                    return ((Number)deserialised).byteValue();
                }
                if (type == Short.class) {
                    return ((Number)deserialised).shortValue();
                }
                if (type == Float.class) {
                    return Float.valueOf(((Number)deserialised).floatValue());
                }
                if (type == Double.class) {
                    return ((Number)deserialised).doubleValue();
                }
                if (type == Integer.class) {
                    return ((Number)deserialised).intValue();
                }
            }
        }
        return deserialised;
    }

    private static void deserialiseMap(Map<String, Object> map, DataKey root, PersistField field) {
        for (DataKey subKey : root.getRelative(field.key).getSubKeys()) {
            Object loaded = PersistenceLoader.deserialiseCollectionValue(field, subKey, field.persistAnnotation.valueType());
            if (loaded == null) continue;
            map.put(subKey.name(), loaded);
        }
    }

    private static Object deserialiseValue(PersistField field, DataKey root) {
        Class<?> type;
        Class<?> clazz = type = field.field.getType().isEnum() ? field.field.getType() : PersistenceLoader.getGenericType(field.field);
        if (field.delegate == null && type.isEnum()) {
            Class<?> clazz2 = type;
            Object obj = root.getRaw("");
            if (obj instanceof String) {
                try {
                    return Enum.valueOf(clazz2, obj.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        Object deserialised = field.delegate == null ? root.getRaw("") : field.delegate.create(root);
        return deserialised;
    }

    private static void ensureDelegateLoaded(Class<? extends Persister<?>> delegateClass) {
        if (loadedDelegates.containsKey(delegateClass)) {
            return;
        }
        try {
            Constructor<Persister<?>> constructor = delegateClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            loadedDelegates.put(delegateClass, constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            loadedDelegates.put(delegateClass, null);
        }
    }

    private static Persister<?> getDelegate(Field field, Class<?> fallback) {
        Persister<?> persister;
        DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
        if (delegate == null) {
            persister = loadedDelegates.get(persistRedirects.get(fallback));
            if (persister == null) {
                return null;
            }
        } else {
            persister = loadedDelegates.get(delegate.value());
        }
        if (persister == null) {
            persister = loadedDelegates.get(persistRedirects.get(fallback));
        }
        return persister;
    }

    private static Field[] getFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = PersistenceLoader.getFieldsFromClass(clazz);
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private static Field[] getFieldsFromClass(Class<?> clazz) {
        ArrayList toFilter = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        for (Class<?> superClass = clazz.getSuperclass(); superClass != Object.class && superClass != null; superClass = superClass.getSuperclass()) {
            toFilter.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        Iterator itr = toFilter.iterator();
        while (itr.hasNext()) {
            Field field = (Field)itr.next();
            field.setAccessible(true);
            Persist persistAnnotation = field.getAnnotation(Persist.class);
            if (persistAnnotation == null) {
                itr.remove();
                continue;
            }
            DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
            if (delegate == null) continue;
            Class<? extends Persister<?>> delegateClass = delegate.value();
            PersistenceLoader.ensureDelegateLoaded(delegateClass);
            Persister<?> in = loadedDelegates.get(delegateClass);
            if (in != null) continue;
            itr.remove();
        }
        return toFilter.toArray(new Field[toFilter.size()]);
    }

    private static Class<?> getGenericType(Field field) {
        if (field.getGenericType() == null || !(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        return args.length > 0 && args[0] instanceof Class ? (Class)args[0] : field.getType();
    }

    public static <T> T load(Class<? extends T> clazz, DataKey root) {
        T instance = null;
        try {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 0) continue;
                constructor.setAccessible(true);
                instance = (T)constructor.newInstance(new Object[0]);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (instance == null) {
            return null;
        }
        return PersistenceLoader.load(instance, root);
    }

    public static <T> T load(T instance, DataKey root) {
        Field[] fields;
        Class<?> clazz = instance.getClass();
        for (Field field : fields = PersistenceLoader.getFields(clazz)) {
            try {
                PersistenceLoader.deserialise(new PersistField(field, instance), root);
            }
            catch (Exception e) {
                if (e != loadException) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (instance instanceof Persistable) {
            ((Persistable)instance).load(root);
        }
        return instance;
    }

    public static void registerPersistDelegate(Class<?> clazz, Class<? extends Persister<?>> delegateClass) {
        persistRedirects.put(clazz, delegateClass);
        PersistenceLoader.ensureDelegateLoaded(delegateClass);
    }

    public static void save(Object instance, DataKey root) {
        Field[] fields;
        Class<?> clazz = instance.getClass();
        for (Field field : fields = PersistenceLoader.getFields(clazz)) {
            PersistenceLoader.serialise(new PersistField(field, instance), root);
        }
        if (instance instanceof Persistable) {
            ((Persistable)instance).save(root);
        }
    }

    private static void serialise(PersistField field, DataKey root) {
        if (field.get() == null) {
            return;
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            Collection collection = (Collection)field.get();
            root.removeKey(field.key);
            int i = 0;
            for (Object object : collection) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), object);
                ++i;
            }
        } else if (Map.class.isAssignableFrom(field.getType())) {
            Map map = (Map)field.get();
            root.removeKey(field.key);
            for (Map.Entry entry : map.entrySet()) {
                String key = PersistenceLoader.createRelativeKey(field.key, (String)entry.getKey());
                PersistenceLoader.serialiseValue(field, root.getRelative(key), entry.getValue());
            }
        } else if (float[].class.isAssignableFrom(field.getType())) {
            float[] floats = (float[])field.get();
            root.removeKey(field.key);
            for (int i = 0; i < floats.length; ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), Float.valueOf(floats[i]));
            }
        } else if (double[].class.isAssignableFrom(field.getType())) {
            double[] doubles = (double[])field.get();
            root.removeKey(field.key);
            for (int i = 0; i < doubles.length; ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), doubles[i]);
            }
        } else if (int[].class.isAssignableFrom(field.getType())) {
            int[] ints = (int[])field.get();
            root.removeKey(field.key);
            for (int i = 0; i < ints.length; ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), ints[i]);
            }
        } else {
            PersistenceLoader.serialiseValue(field, root.getRelative(field.key), field.get());
        }
    }

    private static void serialiseValue(PersistField field, DataKey root, Object value) {
        if (field.delegate != null) {
            field.delegate.save(value, root);
        } else if (value instanceof Enum) {
            root.setRaw("", ((Enum)value).name());
        } else {
            root.setRaw("", value);
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(Location.class, LocationPersister.class);
        PersistenceLoader.registerPersistDelegate(ItemStack.class, ItemStackPersister.class);
        PersistenceLoader.registerPersistDelegate(EulerAngle.class, EulerAnglePersister.class);
        PersistenceLoader.registerPersistDelegate(UUID.class, UUIDPersister.class);
    }

    private static class PersistField {
        private final Persister<?> delegate;
        private final Field field;
        private final Object instance;
        private final String key;
        private final Persist persistAnnotation;
        private Object value;
        private static final Object NULL = new Object();

        private PersistField(Field field, Object instance) {
            this.field = field;
            this.persistAnnotation = field.getAnnotation(Persist.class);
            this.key = this.persistAnnotation.value().equals("UNINITIALISED") ? field.getName() : this.persistAnnotation.value();
            Class fallback = field.getType();
            if (field.getGenericType() instanceof ParameterizedType) {
                fallback = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            }
            this.delegate = PersistenceLoader.getDelegate(field, fallback);
            this.instance = instance;
        }

        public <T> T get() {
            if (this.value == null) {
                try {
                    this.value = this.field.get(this.instance);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.value = NULL;
                }
            }
            if (this.value == NULL) {
                return null;
            }
            return (T)this.value;
        }

        public Class<?> getCollectionType() {
            return this.persistAnnotation.collectionType();
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public boolean isRequired() {
            return this.persistAnnotation.required();
        }

        public void set(Object value) {
            try {
                this.field.set(this.instance, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

