/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.FileStorage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements FileStorage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;

    public YamlStorage(File file) {
        this(file, null);
    }

    public YamlStorage(File file, String header) {
        this.file = file;
        if (!file.exists()) {
            this.create();
            if (header != null) {
                this.config.options().header(header);
            }
            this.save();
        }
    }

    private void create() {
        try {
            Bukkit.getLogger().log(Level.INFO, "Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not create file: " + this.file.getName());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlStorage other = (YamlStorage)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public YamlKey getKey(String root) {
        return new YamlKey(root);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    @Override
    public boolean load() {
        try {
            this.config.load(this.file);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean pathExists(String key) {
        return this.config.get(key) != null;
    }

    @Override
    public void save() {
        try {
            Files.createParentDirs((File)this.file);
            File temporaryFile = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            temporaryFile.deleteOnExit();
            this.config.save(temporaryFile);
            this.file.delete();
            temporaryFile.renameTo(this.file);
            temporaryFile.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    public class YamlKey
    extends DataKey {
        public YamlKey(String root) {
            super(root);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            YamlKey other = (YamlKey)obj;
            return this.getOuterType().equals(other.getOuterType());
        }

        @Override
        public boolean getBoolean(String key) {
            String path = this.createRelativeKey(key);
            if (YamlStorage.this.pathExists(path)) {
                if (YamlStorage.this.config.getString(path) == null) {
                    return YamlStorage.this.config.getBoolean(path);
                }
                return Boolean.parseBoolean(YamlStorage.this.config.getString(path));
            }
            return false;
        }

        @Override
        public boolean getBoolean(String key, boolean def) {
            return YamlStorage.this.config.getBoolean(this.createRelativeKey(key), def);
        }

        @Override
        public double getDouble(String key) {
            return this.getDouble(key, 0.0);
        }

        @Override
        public double getDouble(String key, double def) {
            String path = this.createRelativeKey(key);
            if (YamlStorage.this.pathExists(path)) {
                Object value = YamlStorage.this.config.get(path);
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                String raw = value.toString();
                if (raw.isEmpty()) {
                    return def;
                }
                return Double.parseDouble(raw);
            }
            return def;
        }

        @Override
        public int getInt(String key) {
            return this.getInt(key, 0);
        }

        @Override
        public int getInt(String key, int def) {
            String path = this.createRelativeKey(key);
            if (YamlStorage.this.pathExists(path)) {
                Object value = YamlStorage.this.config.get(path);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                String raw = value.toString();
                if (raw.isEmpty()) {
                    return def;
                }
                return Integer.parseInt(raw);
            }
            return def;
        }

        @Override
        public long getLong(String key) {
            return this.getLong(key, 0L);
        }

        @Override
        public long getLong(String key, long def) {
            String path = this.createRelativeKey(key);
            if (YamlStorage.this.pathExists(path)) {
                Object value = YamlStorage.this.config.get(path);
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                String raw = value.toString();
                if (raw.isEmpty()) {
                    return def;
                }
                return Long.parseLong(raw);
            }
            return def;
        }

        private YamlStorage getOuterType() {
            return YamlStorage.this;
        }

        @Override
        public Object getRaw(String key) {
            return YamlStorage.this.config.get(this.createRelativeKey(key));
        }

        @Override
        public YamlKey getRelative(String relative) {
            if (relative == null || relative.isEmpty()) {
                return this;
            }
            return new YamlKey(this.createRelativeKey(relative));
        }

        public YamlStorage getStorage() {
            return YamlStorage.this;
        }

        @Override
        public String getString(String key) {
            String path = this.createRelativeKey(key);
            if (YamlStorage.this.pathExists(path)) {
                return YamlStorage.this.config.get(path).toString();
            }
            return "";
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            ConfigurationSection section = YamlStorage.this.config.getConfigurationSection(this.path);
            if (section == null) {
                return Collections.emptyList();
            }
            ArrayList<DataKey> res = new ArrayList<DataKey>();
            for (String key : section.getKeys(false)) {
                res.add(this.getRelative(key));
            }
            return res;
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            ConfigurationSection subSection = YamlStorage.this.config.getConfigurationSection(this.path);
            return subSection == null ? Collections.emptyMap() : subSection.getValues(true);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 31 * super.hashCode() + this.getOuterType().hashCode();
            return result;
        }

        @Override
        public boolean keyExists(String key) {
            Object value = YamlStorage.this.config.get(this.createRelativeKey(key));
            return value != null;
        }

        @Override
        public String name() {
            int last = this.path.lastIndexOf(46);
            return this.path.substring(last == 0 ? 0 : last + 1);
        }

        @Override
        public void removeKey(String key) {
            YamlStorage.this.config.set(this.createRelativeKey(key), null);
        }

        @Override
        public void setBoolean(String key, boolean value) {
            YamlStorage.this.config.set(this.createRelativeKey(key), (Object)value);
        }

        @Override
        public void setDouble(String key, double value) {
            YamlStorage.this.config.set(this.createRelativeKey(key), (Object)String.valueOf(value));
        }

        @Override
        public void setInt(String key, int value) {
            YamlStorage.this.config.set(this.createRelativeKey(key), (Object)value);
        }

        @Override
        public void setLong(String key, long value) {
            YamlStorage.this.config.set(this.createRelativeKey(key), (Object)value);
        }

        @Override
        public void setRaw(String key, Object value) {
            YamlStorage.this.config.set(this.createRelativeKey(key), value);
        }

        @Override
        public void setString(String key, String value) {
            YamlStorage.this.config.set(this.createRelativeKey(key), (Object)value);
        }

        public String toString() {
            return "YamlKey [path=" + this.path + "]";
        }
    }
}

