/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensDeserialiseMetaEvent;
import net.citizensnpcs.api.event.CitizensSerialiseMetaEvent;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemStorage {
    private static boolean SUPPORTS_1_14_API = true;
    private static boolean SUPPORTS_ATTRIBUTES = true;
    private static boolean SUPPORTS_CUSTOM_MODEL_DATA = true;

    private static void deserialiseBanner(DataKey root, Banner meta) {
        if (root.keyExists("banner.basecolor")) {
            meta.setBaseColor(DyeColor.valueOf((String)root.getString("banner.basecolor")));
        }
        if (root.keyExists("banner.patterns")) {
            for (DataKey sub : root.getRelative("banner.patterns").getIntegerSubKeys()) {
                Pattern pattern = new Pattern(DyeColor.valueOf((String)sub.getString("color")), PatternType.getByIdentifier((String)sub.getString("type")));
                meta.addPattern(pattern);
            }
        }
    }

    private static Iterable<Color> deserialiseColors(DataKey key) {
        ArrayList colors = Lists.newArrayList();
        for (DataKey sub : key.getIntegerSubKeys()) {
            colors.add(Color.fromRGB((int)sub.getInt("rgb")));
        }
        return colors;
    }

    private static Enchantment deserialiseEnchantment(String string) {
        Enchantment enchantment = null;
        if (SpigotUtil.isUsing1_13API()) {
            enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)string.toLowerCase()));
        }
        if (enchantment == null) {
            enchantment = Enchantment.getByName((String)string);
        }
        return enchantment;
    }

    private static Map<Enchantment, Integer> deserialiseEnchantments(DataKey root, ItemStack res) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (DataKey subKey : root.getSubKeys()) {
            Enchantment enchantment = ItemStorage.deserialiseEnchantment(subKey.name());
            if (enchantment == null) continue;
            enchantments.put(enchantment, subKey.getInt(""));
        }
        return enchantments;
    }

    private static FireworkEffect deserialiseFireworkEffect(DataKey key) {
        FireworkEffect.Builder effect = FireworkEffect.builder();
        effect.flicker(key.getBoolean("flicker"));
        effect.trail(key.getBoolean("trail"));
        effect.with(FireworkEffect.Type.valueOf((String)key.getString("type")));
        effect.withColor(ItemStorage.deserialiseColors(key.getRelative("colors")));
        effect.withFade(ItemStorage.deserialiseColors(key.getRelative("fadecolors")));
        return effect.build();
    }

    private static void deserialiseMeta(DataKey root, ItemStack res) {
        Object meta;
        if (root.keyExists("encoded-meta")) {
            byte[] raw = BaseEncoding.base64().decode((CharSequence)root.getString("encoded-meta"));
            try {
                BukkitObjectInputStream inp = new BukkitObjectInputStream((InputStream)new ByteArrayInputStream(raw));
                ItemMeta itemMeta = (ItemMeta)inp.readObject();
                res.setItemMeta(itemMeta);
                Bukkit.getPluginManager().callEvent((Event)new CitizensDeserialiseMetaEvent(root, res));
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (SUPPORTS_CUSTOM_MODEL_DATA) {
            try {
                if (root.keyExists("custommodel")) {
                    meta = ItemStorage.ensureMeta(res);
                    meta.setCustomModelData(Integer.valueOf(root.getInt("custommodel")));
                    res.setItemMeta(meta);
                }
            }
            catch (Throwable t) {
                SUPPORTS_CUSTOM_MODEL_DATA = false;
            }
        }
        if (root.keyExists("flags")) {
            meta = ItemStorage.ensureMeta(res);
            for (DataKey dataKey : root.getRelative("flags").getIntegerSubKeys()) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)dataKey.getString(""))});
            }
            res.setItemMeta(meta);
        }
        if (root.keyExists("lore")) {
            meta = ItemStorage.ensureMeta(res);
            Iterator<DataKey> lore = Lists.newArrayList();
            for (DataKey key : root.getRelative("lore").getIntegerSubKeys()) {
                lore.add((DataKey)((Object)key.getString("")));
            }
            meta.setLore((List)((Object)lore));
            res.setItemMeta(meta);
        }
        if (root.keyExists("displayname")) {
            meta = ItemStorage.ensureMeta(res);
            meta.setDisplayName(root.getString("displayname"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("firework")) {
            meta = (FireworkMeta)ItemStorage.ensureMeta(res);
            for (DataKey dataKey : root.getRelative("firework.effects").getIntegerSubKeys()) {
                meta.addEffect(ItemStorage.deserialiseFireworkEffect(dataKey));
            }
            meta.setPower(root.getInt("firework.power"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("book")) {
            meta = (BookMeta)ItemStorage.ensureMeta(res);
            for (DataKey dataKey : root.getRelative("book.pages").getIntegerSubKeys()) {
                meta.addPage(new String[]{dataKey.getString("")});
            }
            meta.setTitle(root.getString("book.title"));
            meta.setAuthor(root.getString("book.author"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("armor")) {
            meta = (LeatherArmorMeta)ItemStorage.ensureMeta(res);
            meta.setColor(Color.fromRGB((int)root.getInt("armor.color")));
            res.setItemMeta(meta);
        }
        if (root.keyExists("map")) {
            meta = (MapMeta)ItemStorage.ensureMeta(res);
            meta.setScaling(root.getBoolean("map.scaling"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("blockstate")) {
            meta = (BlockStateMeta)ItemStorage.ensureMeta(res);
            if (root.keyExists("blockstate.banner")) {
                Banner banner = (Banner)meta.getBlockState();
                ItemStorage.deserialiseBanner(root.getRelative("blockstate"), banner);
                banner.update(true);
                meta.setBlockState((BlockState)banner);
            }
            res.setItemMeta(meta);
        }
        if (root.keyExists("enchantmentstorage")) {
            meta = (EnchantmentStorageMeta)ItemStorage.ensureMeta(res);
            for (DataKey dataKey : root.getRelative("enchantmentstorage").getSubKeys()) {
                meta.addStoredEnchant(ItemStorage.deserialiseEnchantment(dataKey.name()), dataKey.getInt(""), true);
            }
            res.setItemMeta(meta);
        }
        if (root.keyExists("skull")) {
            meta = (SkullMeta)ItemStorage.ensureMeta(res);
            if (root.keyExists("skull.owner") && !root.getString("skull.owner").isEmpty()) {
                meta.setOwner(root.getString("skull.owner", ""));
            }
            if (root.keyExists("skull.texture") && !root.getString("skull.texture").isEmpty()) {
                CitizensAPI.getSkullMetaProvider().setTexture(root.getString("skull.texture", ""), (SkullMeta)meta);
            }
            res.setItemMeta(meta);
        }
        if (root.keyExists("banner")) {
            meta = (BannerMeta)ItemStorage.ensureMeta(res);
            if (root.keyExists("banner.basecolor")) {
                meta.setBaseColor(DyeColor.valueOf((String)root.getString("banner.basecolor")));
            }
            if (root.keyExists("banner.patterns")) {
                for (DataKey dataKey : root.getRelative("banner.patterns").getIntegerSubKeys()) {
                    Pattern pattern = new Pattern(DyeColor.valueOf((String)dataKey.getString("color")), PatternType.getByIdentifier((String)dataKey.getString("type")));
                    meta.addPattern(pattern);
                }
            }
            res.setItemMeta(meta);
        }
        if (root.keyExists("potion")) {
            meta = (PotionMeta)ItemStorage.ensureMeta(res);
            try {
                PotionData data = new PotionData(PotionType.valueOf((String)root.getString("potion.data.type")), root.getBoolean("potion.data.extended"), root.getBoolean("potion.data.upgraded"));
                meta.setBasePotionData(data);
            }
            catch (Throwable data) {
                // empty catch block
            }
            for (DataKey dataKey : root.getRelative("potion.effects").getIntegerSubKeys()) {
                int duration = dataKey.getInt("duration");
                int amplifier = dataKey.getInt("amplifier");
                PotionEffectType type = PotionEffectType.getByName((String)dataKey.getString("type"));
                boolean ambient = dataKey.getBoolean("ambient");
                meta.addCustomEffect(new PotionEffect(type, duration, amplifier, ambient), true);
            }
            res.setItemMeta(meta);
        }
        if (root.keyExists("crossbow") && SUPPORTS_1_14_API) {
            meta = null;
            try {
                meta = (CrossbowMeta)ItemStorage.ensureMeta(res);
            }
            catch (Throwable t) {
                SUPPORTS_1_14_API = false;
            }
            if (meta != null) {
                for (DataKey dataKey : root.getRelative("crossbow.projectiles").getSubKeys()) {
                    meta.addChargedProjectile(ItemStorage.loadItemStack(dataKey));
                }
                res.setItemMeta(meta);
            }
        }
        if (root.keyExists("repaircost") && res.getItemMeta() instanceof Repairable) {
            meta = ItemStorage.ensureMeta(res);
            ((Repairable)meta).setRepairCost(root.getInt("repaircost"));
            res.setItemMeta(meta);
        }
        if (root.keyExists("attributes") && SUPPORTS_ATTRIBUTES) {
            meta = ItemStorage.ensureMeta(res);
            try {
                for (DataKey dataKey : root.getRelative("attributes").getSubKeys()) {
                    Attribute attribute = Attribute.valueOf((String)dataKey.name());
                    for (DataKey modifier : dataKey.getIntegerSubKeys()) {
                        UUID uuid = UUID.fromString(modifier.getString("uuid"));
                        String name = modifier.getString("name");
                        double amount = modifier.getDouble("amount");
                        AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)modifier.getString("operation"));
                        EquipmentSlot slot = modifier.keyExists("slot") ? EquipmentSlot.valueOf((String)modifier.getString("slot")) : null;
                        meta.addAttributeModifier(attribute, new AttributeModifier(uuid, name, amount, operation, slot));
                    }
                }
            }
            catch (Throwable e) {
                SUPPORTS_ATTRIBUTES = false;
            }
            res.setItemMeta(meta);
        }
        if ((meta = res.getItemMeta()) != null) {
            try {
                meta.setUnbreakable(root.getBoolean("unbreakable", false));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            res.setItemMeta(meta);
        }
        Bukkit.getPluginManager().callEvent((Event)new CitizensDeserialiseMetaEvent(root, res));
    }

    private static <T extends ItemMeta> T ensureMeta(ItemStack stack) {
        if (!stack.hasItemMeta()) {
            stack.setItemMeta(Bukkit.getServer().getItemFactory().getItemMeta(stack.getType()));
        }
        return (T)stack.getItemMeta();
    }

    public static ItemStack loadItemStack(DataKey root) {
        Material material = null;
        if (root.keyExists("type_key")) {
            NamespacedKey key = new NamespacedKey(root.getString("type_namespace"), root.getString("type_key"));
            material = Material.getMaterial((String)key.getKey().toUpperCase(), (boolean)false);
        } else {
            String raw = root.getString("type", root.getString("id"));
            if (raw == null || raw.length() == 0) {
                return null;
            }
            Material material2 = material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)raw, (boolean)true) : Material.matchMaterial((String)raw);
        }
        if (material == null || material == Material.AIR) {
            return null;
        }
        ItemStack res = new ItemStack(material, root.getInt("amount"), (short)root.getInt("durability", root.getInt("data", 0)));
        if (root.keyExists("mdata") && res.getData() != null) {
            res.getData().setData((byte)root.getInt("mdata"));
        }
        if (root.keyExists("enchantments")) {
            Map<Enchantment, Integer> enchantments = ItemStorage.deserialiseEnchantments(root.getRelative("enchantments"), res);
            res.addUnsafeEnchantments(enchantments);
        }
        ItemStorage.deserialiseMeta(root.getRelative("meta"), res);
        return res;
    }

    private static void migrateForSave(DataKey key) {
        key.removeKey("data");
        key.removeKey("id");
    }

    public static void saveItem(DataKey key, ItemStack item) {
        if (item == null) {
            item = new ItemStack(Material.AIR);
        }
        ItemStorage.migrateForSave(key);
        if (SpigotUtil.isUsing1_13API()) {
            key.setString("type_namespace", item.getType().getKey().getNamespace());
            key.setString("type_key", item.getType().getKey().getKey());
        } else {
            key.setString("type", item.getType().name());
        }
        key.setInt("amount", item.getAmount());
        key.setInt("durability", item.getDurability());
        if (item.getData() != null) {
            key.setInt("mdata", item.getData().getData());
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            ItemStorage.serialiseMeta(key.getRelative("meta"), meta);
        } else {
            key.removeKey("meta");
        }
        ItemStorage.serialiseEnchantments(key.getRelative("enchantments"), item.getEnchantments());
    }

    private static void serialiseEnchantments(DataKey key, Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> enchantment : enchantments.entrySet()) {
            key.setInt(SpigotUtil.isUsing1_13API() ? enchantment.getKey().getKey().getKey() : enchantment.getKey().getName(), enchantment.getValue());
        }
    }

    private static void serialiseMeta(DataKey key, ItemMeta meta) {
        key.removeKey("encoded-meta");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BukkitObjectOutputStream bukkitOut = new BukkitObjectOutputStream((OutputStream)out);
            bukkitOut.writeObject((Object)meta);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            Messaging.severe("Spigot error when saving item meta");
            e.printStackTrace();
            return;
        }
        String encoded = BaseEncoding.base64().encode(out.toByteArray());
        key.setString("encoded-meta", encoded);
        Bukkit.getPluginManager().callEvent((Event)new CitizensSerialiseMetaEvent(key, meta));
    }
}

