/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import me.clip.placeholderapi.PlaceholderAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class Placeholders {
    private static final String[] CITIZENS_PLACEHOLDERS = new String[]{"<id>", "<npc>", "<owner>"};
    private static boolean PLACEHOLDERAPI_ENABLED = true;
    private static final String[] PLAYER_PLACEHOLDERS = new String[]{"<player>", "<p>"};
    private static final String[] PLAYER_WORLD_PLACEHOLDERS = new String[]{"<player>", "<p>", "<world>"};

    public static String replace(String text, CommandSender sender, NPC npc) {
        text = Placeholders.replace(text, sender instanceof OfflinePlayer ? (OfflinePlayer)sender : null);
        if (npc == null) {
            return text;
        }
        return StringUtils.replaceEach((String)text, (String[])CITIZENS_PLACEHOLDERS, (String[])new String[]{Integer.toString(npc.getId()), npc.getName(), npc.getOrAddTrait(Owner.class).getOwner()});
    }

    public static String replace(String text, OfflinePlayer player) {
        if (player == null) {
            return Placeholders.setPlaceholderAPIPlaceholders(text, player);
        }
        text = player instanceof Entity && ((Entity)player).isValid() ? StringUtils.replaceEach((String)text, (String[])PLAYER_WORLD_PLACEHOLDERS, (String[])new String[]{player.getName(), player.getName(), ((Entity)player).getWorld().getName()}) : StringUtils.replaceEach((String)text, (String[])PLAYER_PLACEHOLDERS, (String[])new String[]{player.getName(), player.getName()});
        return Placeholders.setPlaceholderAPIPlaceholders(text, player);
    }

    private static String setPlaceholderAPIPlaceholders(String text, OfflinePlayer player) {
        if (!PLACEHOLDERAPI_ENABLED) {
            return text;
        }
        try {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
        }
        catch (Throwable t) {
            PLACEHOLDERAPI_ENABLED = false;
            return text;
        }
    }
}

