/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.ListIterator;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCOpenDoorEvent;
import net.citizensnpcs.api.event.NPCOpenGateEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.event.Event;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;

public class DoorExaminer
implements BlockExaminer {
    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Material in = source.getMaterialAt(point.getVector());
        if (MinecraftBlockExaminer.isDoor(in) || MinecraftBlockExaminer.isGate(in)) {
            point.addCallback(new DoorOpener());
            return BlockExaminer.PassableState.PASSABLE;
        }
        return BlockExaminer.PassableState.IGNORE;
    }

    static class DoorOpener
    implements PathPoint.PathCallback {
        boolean opened = false;
        private static boolean SUPPORTS_SOUNDS = true;

        DoorOpener() {
        }

        private void close(Block point) {
            this.closeOpenable(point);
        }

        private void closeOpenable(Block point) {
            if (SpigotUtil.isUsing1_13API()) {
                Openable open = (Openable)point.getBlockData();
                if (!open.isOpen()) {
                    return;
                }
                open.setOpen(false);
                point.setBlockData((BlockData)open);
            } else {
                BlockState state = (point = this.getCorrectDoor(point)).getState();
                org.bukkit.material.Openable open = (org.bukkit.material.Openable)state.getData();
                if (!open.isOpen()) {
                    return;
                }
                open.setOpen(false);
                state.setData((MaterialData)open);
                state.update();
            }
            if (SUPPORTS_SOUNDS) {
                try {
                    Sound sound = MinecraftBlockExaminer.isDoor(point.getType()) ? (point.getType() == Material.IRON_DOOR ? Sound.BLOCK_IRON_DOOR_CLOSE : Sound.BLOCK_WOODEN_DOOR_CLOSE) : Sound.BLOCK_FENCE_GATE_CLOSE;
                    point.getWorld().playSound(point.getLocation(), sound, 10.0f, 1.0f);
                }
                catch (Exception ex) {
                    SUPPORTS_SOUNDS = false;
                }
            }
        }

        private Block getCorrectDoor(Block point) {
            MaterialData data = point.getState().getData();
            if (data instanceof Door) {
                return point;
            }
            Door door = (Door)data;
            boolean bottom = !door.isTopHalf();
            return bottom ? point : point.getRelative(BlockFace.DOWN);
        }

        private void open(NPC npc, Block point) {
            if (SpigotUtil.isUsing1_13API()) {
                Openable open = (Openable)point.getBlockData();
                if (open.isOpen()) {
                    return;
                }
                NPCEvent event = MinecraftBlockExaminer.isDoor(point.getType()) ? new NPCOpenDoorEvent(npc, point) : new NPCOpenGateEvent(npc, point);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                open.setOpen(true);
                point.setBlockData((BlockData)open);
                this.opened = true;
            } else {
                BlockState state = (point = this.getCorrectDoor(point)).getState();
                org.bukkit.material.Openable open = (org.bukkit.material.Openable)state.getData();
                if (open.isOpen()) {
                    return;
                }
                NPCEvent event = MinecraftBlockExaminer.isDoor(point.getType()) ? new NPCOpenDoorEvent(npc, point) : new NPCOpenGateEvent(npc, point);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                open.setOpen(true);
                state.setData((MaterialData)open);
                state.update();
                this.opened = true;
            }
            if (SUPPORTS_SOUNDS) {
                try {
                    Sound sound = MinecraftBlockExaminer.isDoor(point.getType()) ? (point.getType() == Material.IRON_DOOR ? Sound.BLOCK_IRON_DOOR_OPEN : Sound.BLOCK_WOODEN_DOOR_OPEN) : Sound.BLOCK_FENCE_GATE_OPEN;
                    point.getWorld().playSound(point.getLocation(), sound, 10.0f, 1.0f);
                }
                catch (Exception ex) {
                    SUPPORTS_SOUNDS = false;
                }
            }
        }

        @Override
        public void run(NPC npc, Block point, ListIterator<Block> path) {
            if (!MinecraftBlockExaminer.isDoor(point.getType())) {
                return;
            }
            if (npc.getStoredLocation().distanceSquared(point.getLocation().add(0.5, 0.0, 0.5)) > 4.0) {
                if (this.opened) {
                    this.close(point);
                    this.opened = false;
                }
                return;
            }
            this.open(npc, point);
        }
    }
}

