/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;

public class Paginator {
    private boolean console;
    private String header;
    private final List<String> lines = new ArrayList<String>();
    private static final int LINES_PER_PAGE = 9;

    public void addLine(String line) {
        this.lines.add(line);
    }

    public Paginator console(boolean console) {
        this.console = console;
        return this;
    }

    public Paginator header(String header) {
        this.header = header;
        return this;
    }

    public boolean sendPage(CommandSender sender, int page) {
        int linesPerPage = this.console ? 200 : 9;
        int pages = (int)(Math.ceil((double)this.lines.size() / (double)linesPerPage) == 0.0 ? 1.0 : Math.ceil((double)this.lines.size() / (double)linesPerPage));
        if (page <= 0 || page > pages) {
            return false;
        }
        int startIndex = linesPerPage * page - linesPerPage;
        int endIndex = page * linesPerPage;
        Messaging.send(sender, Paginator.wrapHeader("[[" + this.header + " <f>" + page + "/" + pages));
        if (this.lines.size() < endIndex) {
            endIndex = this.lines.size();
        }
        for (String line : this.lines.subList(startIndex, endIndex)) {
            Messaging.send(sender, line);
        }
        return true;
    }

    public static String wrapHeader(Object string) {
        return "[[=====[ " + string.toString() + " [[]=====";
    }
}

