/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryMenuSlot {
    private Set<ClickType> clickFilter = EnumSet.allOf(ClickType.class);
    private final int index;
    private final Inventory inventory;

    public InventoryMenuSlot(MenuContext menu, int i) {
        this.inventory = menu.getInventory();
        this.index = i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InventoryMenuSlot other = (InventoryMenuSlot)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.inventory == null ? other.inventory != null : !this.inventory.equals(other.inventory));
    }

    public int hashCode() {
        int result = 31 + this.index;
        return 31 * result + (this.inventory == null ? 0 : this.inventory.hashCode());
    }

    public void initialise(MenuSlot data) {
        ItemStack defaultItem = null;
        if (data.material() != null) {
            defaultItem = new ItemStack(data.material(), data.amount());
        }
        this.inventory.setItem(this.index, defaultItem);
        this.setClickFilter(Arrays.asList(data.filter()));
    }

    public void setClickFilter(Collection<ClickType> filter) {
        this.clickFilter = EnumSet.copyOf(filter);
    }
}

