/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.InventoryMenuTransition;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.gui.MenuTransition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class InventoryMenu
implements Listener {
    private PageContext page;
    private final Queue<PageContext> stack = Queues.newArrayDeque();
    private Collection<InventoryView> views = Lists.newArrayList();
    private static Map<Class<? extends InventoryMenuPage>, InventoryMenuInfo> CACHED_INFOS = new WeakHashMap<Class<? extends InventoryMenuPage>, InventoryMenuInfo>();

    public InventoryMenu(InventoryMenuInfo info) {
        this.transition(info);
    }

    private InventoryMenuSlot createSlot(int pos, MenuSlot slotInfo) {
        InventoryMenuSlot slot = this.page.ctx.getSlot(pos);
        slot.initialise(slotInfo);
        return slot;
    }

    private InventoryMenuTransition createTransition(int pos, MenuTransition transitionInfo) {
        InventoryMenuSlot slot = this.page.ctx.getSlot(pos);
        InventoryMenuTransition transition = new InventoryMenuTransition(this, slot, transitionInfo.value());
        return transition;
    }

    private int getInventorySize(InventoryType type, int[] dim) {
        switch (type) {
            case CHEST: {
                int size = dim[0] * dim[1];
                System.out.println(size + " " + size % 9);
                if (size % 9 != 0) {
                    size += 9 - size % 9;
                }
                return Math.min(54, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.page == null || !event.getInventory().equals(this.page.ctx.getInventory())) {
            return;
        }
        switch (event.getAction()) {
            case COLLECT_TO_CURSOR: {
                event.setCancelled(true);
            }
            case NOTHING: 
            case UNKNOWN: 
            case DROP_ONE_CURSOR: 
            case DROP_ALL_CURSOR: {
                return;
            }
        }
        InventoryMenuSlot slot = this.page.ctx.getSlot(event.getSlot());
        this.page.page.onClick(slot, event);
        slot.onClick(event);
        for (InventoryMenuTransition transition : this.page.transitions) {
            Class<? extends InventoryMenuPage> next = transition.accept(slot);
            if (next == null) continue;
            this.transition(next);
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.page == null || !event.getInventory().equals(this.page.ctx.getInventory())) {
            return;
        }
        this.page.page.onClose(event.getPlayer());
        this.page = this.stack.poll();
        this.transitionViewersToInventory(this.page.ctx.getInventory());
    }

    private int posToIndex(int[] dim, int[] pos) {
        return pos[0] * dim[1] + pos[1];
    }

    public void present(Player player) {
        InventoryView view = player.openInventory(this.page.ctx.getInventory());
        this.views.add(view);
    }

    public void transition(Class<? extends InventoryMenuPage> clazz) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        this.transition(CACHED_INFOS.get(clazz));
    }

    private void transition(InventoryMenuInfo info) {
        int pos;
        int i;
        if (this.page != null) {
            this.stack.add(this.page);
        }
        this.page = new PageContext();
        int[] dim = info.menuAnnotation.dimensions();
        int size = this.getInventorySize(info.menuAnnotation.type(), dim);
        Inventory inventory = info.menuAnnotation.type() == InventoryType.CHEST || info.menuAnnotation.type() == null ? Bukkit.createInventory(null, (int)size, (String)info.menuAnnotation.title()) : Bukkit.createInventory(null, (InventoryType)info.menuAnnotation.type(), (String)info.menuAnnotation.title());
        ArrayList transitions = Lists.newArrayList();
        InventoryMenuSlot[] slots = new InventoryMenuSlot[inventory.getSize()];
        PageContext.access$402(this.page, new InventoryMenuPattern[info.patterns.length]);
        try {
            this.page.page = info.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.page.ctx = new MenuContext(this, slots, inventory);
        for (i = 0; i < info.slots.length; ++i) {
            Bindable<MenuSlot> slotInfo = info.slots[i];
            pos = this.posToIndex(dim, ((MenuSlot)slotInfo.data).value());
            InventoryMenuSlot slot = this.createSlot(pos, (MenuSlot)slotInfo.data);
            slotInfo.bind(this.page.page, slot);
        }
        for (i = 0; i < info.transitions.length; ++i) {
            Bindable<MenuTransition> transitionInfo = info.transitions[i];
            pos = this.posToIndex(dim, ((MenuTransition)transitionInfo.data).pos());
            InventoryMenuTransition transition = this.createTransition(pos, (MenuTransition)transitionInfo.data);
            transitionInfo.bind(this.page.page, transition);
            transitions.add(transition);
        }
        for (i = 0; i < info.patterns.length; ++i) {
            int pos2;
            Bindable<MenuPatternInfo> patternInfo = info.patterns[i];
            ArrayList patternSlots = Lists.newArrayList();
            ArrayList patternTransitions = Lists.newArrayList();
            for (MenuSlot slot : ((MenuPatternInfo)patternInfo.data).slots) {
                pos2 = this.posToIndex(dim, slot.value());
                patternSlots.add(this.createSlot(pos2, slot));
            }
            for (MenuTransition transition : ((MenuPatternInfo)patternInfo.data).transitions) {
                pos2 = this.posToIndex(dim, transition.pos());
                InventoryMenuTransition concreteTransition = this.createTransition(pos2, transition);
                patternTransitions.add(concreteTransition);
                transitions.add(concreteTransition);
            }
            InventoryMenuPattern pat = new InventoryMenuPattern(((MenuPatternInfo)patternInfo.data).info, patternSlots, patternTransitions);
            patternInfo.bind(this.page.page, pat);
            ((PageContext)this.page).patterns[i] = pat;
        }
        PageContext.access$202(this.page, transitions.toArray(new InventoryMenuTransition[transitions.size()]));
        this.transitionViewersToInventory(inventory);
    }

    private void transitionViewersToInventory(Inventory inventory) {
        Collection<InventoryView> old = this.views;
        this.views = Lists.newArrayListWithExpectedSize((int)old.size());
        for (InventoryView view : old) {
            view.close();
            if (!view.getPlayer().isValid() || inventory == null) continue;
            this.views.add(view.getPlayer().openInventory(inventory));
        }
    }

    private static void cacheInfo(Class<? extends InventoryMenuPage> clazz) {
        InventoryMenuInfo info = new InventoryMenuInfo(clazz);
        info.menuAnnotation = clazz.getAnnotation(Menu.class);
        if (info.menuAnnotation == null) {
            throw new IllegalArgumentException("Missing menu annotation");
        }
        try {
            Constructor<? extends InventoryMenuPage> found = clazz.getDeclaredConstructor(new Class[0]);
            found.setAccessible(true);
            info.constructor = found;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        CACHED_INFOS.put(clazz, info);
    }

    public static InventoryMenu create(Class<? extends InventoryMenuPage> clazz) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        InventoryMenuInfo info = CACHED_INFOS.get(clazz);
        return new InventoryMenu(info);
    }

    private static class PageContext {
        private MenuContext ctx;
        private InventoryMenuPage page;
        private InventoryMenuPattern[] patterns;
        private InventoryMenuTransition[] transitions;

        private PageContext() {
        }

        static /* synthetic */ InventoryMenuPattern[] access$402(PageContext x0, InventoryMenuPattern[] x1) {
            x0.patterns = x1;
            return x1;
        }

        static /* synthetic */ InventoryMenuTransition[] access$202(PageContext x0, InventoryMenuTransition[] x1) {
            x0.transitions = x1;
            return x1;
        }
    }

    private static class MenuPatternInfo {
        MenuPattern info;
        Collection<MenuSlot> slots = Lists.newArrayList();
        Collection<MenuTransition> transitions = Lists.newArrayList();

        public MenuPatternInfo(MenuPattern info, Collection<MenuSlot> slots, Collection<MenuTransition> transitions) {
            this.info = info;
            this.slots = slots;
            this.transitions = transitions;
        }
    }

    private static class InventoryMenuInfo {
        Constructor<? extends InventoryMenuPage> constructor;
        Menu menuAnnotation;
        Bindable<MenuPatternInfo>[] patterns;
        Bindable<MenuSlot>[] slots;
        Bindable<MenuTransition>[] transitions;
        private static MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

        public InventoryMenuInfo(Class<?> clazz) {
            this.patterns = this.getPatternBindables(clazz);
            this.slots = this.getBindables(clazz, MenuSlot.class, InventoryMenuSlot.class);
            this.transitions = this.getBindables(clazz, MenuTransition.class, InventoryMenuTransition.class);
        }

        private <T extends Annotation> Bindable<T>[] getBindables(Class<?> clazz, Class<T> annotationType, Class<?> concreteType) {
            ArrayList bindables = Lists.newArrayList();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (((MenuPattern[])field.getAnnotationsByType(MenuPattern.class)).length != 0) continue;
                Annotation[] annotations = field.getAnnotationsByType(annotationType);
                MethodHandle bind = null;
                if (field.getType() == concreteType) {
                    try {
                        bind = LOOKUP.unreflectSetter(field);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                for (Annotation t : annotations) {
                    bindables.add(new Bindable<Annotation>(bind, t));
                }
            }
            ArrayList reflect = Lists.newArrayList();
            reflect.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
            reflect.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            for (AccessibleObject object : reflect) {
                object.setAccessible(true);
                if (((MenuPattern[])object.getAnnotationsByType(MenuPattern.class)).length != 0) continue;
                for (Annotation t : object.getAnnotationsByType(annotationType)) {
                    bindables.add(new Bindable<Annotation>(null, t));
                }
            }
            for (Annotation t : clazz.getAnnotationsByType(annotationType)) {
                bindables.add(new Bindable<Annotation>(null, t));
            }
            return bindables.toArray(new Bindable[bindables.size()]);
        }

        private Bindable<MenuPatternInfo> getPatternBindable(MethodHandle bind, AccessibleObject object) {
            MenuPattern[] annotation = (MenuPattern[])object.getAnnotationsByType(MenuPattern.class);
            if (annotation.length != 1) {
                return null;
            }
            MenuPattern pattern = annotation[0];
            ArrayList slots = Lists.newArrayList();
            for (MenuSlot slot : (MenuSlot[])object.getAnnotationsByType(MenuSlot.class)) {
                if (slot.pat() == '0' || !pattern.value().contains(Character.toString(slot.pat()))) continue;
                slots.add(slot);
            }
            ArrayList transitions = Lists.newArrayList();
            for (MenuTransition transition : (MenuTransition[])object.getAnnotationsByType(MenuTransition.class)) {
                if (transition.pat() == '0' || !pattern.value().contains(Character.toString(transition.pat()))) continue;
                transitions.add(transition);
            }
            return new Bindable<MenuPatternInfo>(bind, new MenuPatternInfo(pattern, slots, transitions));
        }

        private Bindable<MenuPatternInfo> getPatternBindable(MethodHandle bind, Class<?> object) {
            MenuPattern[] annotation = (MenuPattern[])object.getAnnotationsByType(MenuPattern.class);
            if (annotation.length != 1) {
                return null;
            }
            MenuPattern pattern = annotation[0];
            ArrayList slots = Lists.newArrayList();
            for (MenuSlot slot : (MenuSlot[])object.getAnnotationsByType(MenuSlot.class)) {
                if (slot.pat() == '0' || !pattern.value().contains(Character.toString(slot.pat()))) continue;
                slots.add(slot);
            }
            ArrayList transitions = Lists.newArrayList();
            for (MenuTransition transition : (MenuTransition[])object.getAnnotationsByType(MenuTransition.class)) {
                if (transition.pat() == '0' || !pattern.value().contains(Character.toString(transition.pat()))) continue;
                transitions.add(transition);
            }
            return new Bindable<MenuPatternInfo>(bind, new MenuPatternInfo(pattern, slots, transitions));
        }

        private Bindable<MenuPatternInfo>[] getPatternBindables(Class<?> clazz) {
            ArrayList bindables = Lists.newArrayList();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                MethodHandle bind = null;
                if (field.getType() == InventoryMenuPattern.class) {
                    try {
                        bind = LOOKUP.unreflectSetter(field);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                bindables.add(this.getPatternBindable(bind, field));
            }
            ArrayList reflect = Lists.newArrayList();
            reflect.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
            reflect.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            for (AccessibleObject object : reflect) {
                object.setAccessible(true);
                if (((MenuPattern[])object.getAnnotationsByType(MenuPattern.class)).length != 0) continue;
                bindables.add(this.getPatternBindable(null, object));
            }
            bindables.add(this.getPatternBindable(null, clazz));
            return Collections2.filter((Collection)bindables, (Predicate)Predicates.notNull()).toArray(new Bindable[0]);
        }
    }

    private static class Bindable<T> {
        MethodHandle bind;
        T data;

        public Bindable(MethodHandle bind, T data) {
            this.bind = bind;
            this.data = data;
        }

        public void bind(Object instance, Object value) {
            if (this.bind == null) {
                return;
            }
            try {
                this.bind.invoke(instance, value);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

