/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import java.util.Collection;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.util.Vector;

public class SeparationBehavior
implements FlockBehavior {
    private double separation = 0.5;
    private final double weight;

    public SeparationBehavior(double weight) {
        this.weight = weight;
    }

    public SeparationBehavior(double weight, double separation) {
        this.separation = separation;
        this.weight = weight;
    }

    @Override
    public Vector getVector(NPC npc, Collection<NPC> nearby) {
        Vector steering = new Vector(0, 0, 0);
        Vector pos = npc.getEntity().getLocation().toVector();
        int count = 0;
        for (NPC neighbor : nearby) {
            Vector diff;
            double dist;
            if (!neighbor.isSpawned() || (dist = (diff = pos.subtract(neighbor.getEntity().getLocation().toVector()).setY(0)).length()) > this.separation) continue;
            steering = steering.add(diff.normalize().multiply(1.0 / (dist * 50.0)));
            ++count;
        }
        count = Math.max(1, count);
        steering = steering.divide(new Vector(count, count, count));
        return steering.setY(0).multiply(this.weight);
    }
}

