/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryMenuSlot {
    private Set<InventoryAction> actionFilter = EnumSet.allOf(InventoryAction.class);
    private final List<Consumer<CitizensInventoryClickEvent>> handlers = Lists.newArrayList();
    private final int index;
    private final Inventory inventory;

    InventoryMenuSlot(MenuContext menu, int i) {
        this.inventory = menu.getInventory();
        this.index = i;
    }

    public void addClickHandler(Consumer<CitizensInventoryClickEvent> func) {
        this.handlers.add(func);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InventoryMenuSlot other = (InventoryMenuSlot)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.inventory == null ? other.inventory != null : !this.inventory.equals(other.inventory));
    }

    public ItemStack getCurrentItem() {
        return this.inventory.getItem(this.index);
    }

    public Collection<InventoryAction> getFilter() {
        return this.actionFilter;
    }

    public int hashCode() {
        int result = 31 + this.index;
        return 31 * result + (this.inventory == null ? 0 : this.inventory.hashCode());
    }

    void initialise(MenuSlot data) {
        ItemMeta meta;
        ItemStack defaultItem = null;
        if (data.compatMaterial().length == 2) {
            Material mat = Material.getMaterial((String)data.compatMaterial()[0]);
            if (mat == null) {
                mat = Material.getMaterial((String)data.compatMaterial()[1]);
            }
            defaultItem = new ItemStack(mat, data.amount());
        } else if (data.material() != null) {
            defaultItem = new ItemStack(data.material(), data.amount());
        }
        if (defaultItem != null && (meta = defaultItem.getItemMeta()) != null) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            if (!data.lore().equals("EMPTY")) {
                meta.setLore(Arrays.asList(Colorizer.parseColors(Messaging.tryTranslate(data.lore())).split("\\n|\n")));
            }
            if (!data.title().equals("EMPTY")) {
                meta.setDisplayName(Colorizer.parseColors(Messaging.tryTranslate(data.title())));
            }
            defaultItem.setItemMeta(meta);
        }
        this.inventory.setItem(this.index, defaultItem);
        this.setFilter(Arrays.asList(data.filter()));
    }

    void onClick(CitizensInventoryClickEvent event) {
        if (!this.actionFilter.contains(event.getAction())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
        for (Consumer<CitizensInventoryClickEvent> runnable : this.handlers) {
            runnable.accept(event);
        }
    }

    public void setFilter(Collection<InventoryAction> filter) {
        this.actionFilter = filter == null || filter.isEmpty() ? EnumSet.allOf(InventoryAction.class) : EnumSet.copyOf(filter);
    }

    public void setItemStack(ItemStack stack) {
        this.inventory.setItem(this.index, stack);
    }

    public void setItemStack(ItemStack item, String description) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(Arrays.asList(Colorizer.parseColors(description).split("\n")));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        this.inventory.setItem(this.index, item);
    }
}

