/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.base.Function;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import org.bukkit.event.Event;

public class PercentageSlotHandler
implements Consumer<CitizensInventoryClickEvent> {
    private int percentage;
    private final Function<Integer, String> transformer;

    public PercentageSlotHandler(Function<Integer, String> transformer) {
        this(transformer, 100);
    }

    public PercentageSlotHandler(Function<Integer, String> transformer, int initialPercentage) {
        this.transformer = transformer;
        this.percentage = initialPercentage;
    }

    @Override
    public void accept(CitizensInventoryClickEvent event) {
        int dx;
        int n = dx = event.isShiftClick() ? 1 : 10;
        if (event.isRightClick()) {
            dx *= -1;
        }
        this.percentage += dx;
        if (this.percentage < 0) {
            this.percentage = 0;
        } else if (this.percentage > 100) {
            this.percentage = 100;
        }
        event.setCurrentItemDescription((String)this.transformer.apply((Object)this.percentage));
        event.setResult(Event.Result.DENY);
    }
}

